/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.proposal;

import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.proposal.GaussianRandomWalk;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class BoundedRandomWalk
extends GaussianRandomWalk {
    Double a = null;
    Double b = null;

    @Override
    public double logDensity(Object from, Object to) throws Exception {
        Normal dist = (Normal)this.sampling;
        double sig = Math.sqrt(dist.getVariance());
        double x = (Double)to;
        if (x < this.a || x > this.b) {
            return Double.NEGATIVE_INFINITY;
        }
        double mu = (Double)from;
        double zX = (x - mu) / sig;
        double xP = NormalDist.density01((double)zX);
        double bCDF = 1.0;
        if (this.b != Double.POSITIVE_INFINITY) {
            double zB = (this.b - mu) / sig;
            bCDF = NormalDist.cdf01((double)zB);
        }
        double aCDF = 0.0;
        if (this.a != Double.NEGATIVE_INFINITY) {
            double zA = (this.a - mu) / sig;
            aCDF = NormalDist.cdf01((double)zA);
        }
        double f = xP / ((bCDF - aCDF) * sig);
        return Math.log(f);
    }

    @Override
    public Object sample(Object obj) {
        Double samp;
        if (this.a == null) {
            this.a = Double.NEGATIVE_INFINITY;
        }
        if (this.b == null) {
            this.b = Double.POSITIVE_INFINITY;
        }
        do {
            samp = (Double)super.sample(obj);
        } while (!(this.a <= samp) || !(samp <= this.b));
        return samp;
    }

    public void setLowerBound(Double l) {
        this.a = l;
    }

    public void setUpperBound(Double u) {
        this.b = u;
    }
}

