/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class Utils {
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    public static double[] normalizeTo(double[] rawdata, double mu, double sd, double expMu, double expSD) {
        int i;
        double min = 0.0;
        double[] data = new double[rawdata.length];
        for (i = 0; i < data.length; ++i) {
            data[i] = expSD * (rawdata[i] - mu) / sd + expMu;
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        if (min < 0.0) {
            for (i = 0; i < data.length; ++i) {
                data[i] = data[i] - min;
            }
        }
        return data;
    }

    public static double[][] normalize(double[] data, double[] low, double[] high, double targetMu, double targetSD) {
        double[][] ret = new double[3][];
        double dataMu = StatUtils.mean((double[])data);
        double dataSD = Math.sqrt(StatUtils.variance((double[])data, (double)dataMu));
        double[] retData = Utils.normalizeTo(data, dataMu, dataSD, targetMu, targetSD);
        double normMu = StatUtils.mean((double[])retData);
        double normSD = Math.sqrt(StatUtils.variance((double[])retData, (double)normMu));
        double[] retLow = new double[data.length];
        double[] retHigh = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            retLow[i] = retData[i] + (low[i] - data[i]) * targetSD / dataSD;
            retHigh[i] = retData[i] + (high[i] - data[i]) * targetSD / dataSD;
        }
        ret[0] = retLow;
        ret[1] = retData;
        ret[2] = retHigh;
        return ret;
    }

    public static double[] normalizeTo(double[] rawdata, double expMu, double expSD) {
        double mu = StatUtils.mean((double[])rawdata);
        double sd = Math.sqrt(StatUtils.variance((double[])rawdata, (double)mu));
        return Utils.normalizeTo(rawdata, mu, sd, expMu, expSD);
    }

    public static JFreeChart createDeviationChart(String title, String xAxisLabel, String yAxisLabel, IntervalXYDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setAutoRangeIncludesZero(false);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setOrientation(orientation);
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        currentTheme.apply(chart);
        return chart;
    }
}

