/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.stat.StatUtils;
import weka.estimators.KernelEstimator;

public class SummaryStats {
    double[] x;
    double[] p;
    double pMax;
    int modeIndex = -1;
    double[] data;

    public SummaryStats(File inFile, double precision, Integer skip) throws Exception {
        this.readFile(inFile, skip);
        this.pdf(this.kde(precision));
    }

    private void readFile(File infile, Integer skip) throws Exception {
        int i;
        ArrayList<Double> dataList = new ArrayList<Double>();
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        String line = reader.readLine();
        if (skip != null) {
            for (i = 1; i < skip; ++i) {
                line = reader.readLine();
            }
        }
        while (line != null) {
            Double d = new Double(line);
            dataList.add(d);
            line = reader.readLine();
        }
        reader.close();
        this.data = new double[dataList.size()];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = (Double)dataList.get(i);
        }
    }

    private KernelEstimator kde(double precision) throws Exception {
        KernelEstimator estimator = new KernelEstimator(precision);
        for (int i = 0; i < this.data.length; ++i) {
            estimator.addValue(this.data[i], 1.0);
        }
        return estimator;
    }

    private void pdf(KernelEstimator kde) {
        int i;
        int n = kde.getNumKernels();
        this.x = kde.getMeans();
        this.p = new double[n];
        double pTotal = 0.0;
        for (i = 0; i < n; ++i) {
            this.p[i] = kde.getProbability(this.x[i]);
            pTotal += this.p[i];
        }
        this.pMax = 0.0;
        this.modeIndex = -1;
        for (i = 0; i < n; ++i) {
            this.p[i] = this.p[i] / pTotal;
            if (!(this.p[i] > this.pMax)) continue;
            this.pMax = this.p[i];
            this.modeIndex = i;
        }
    }

    public double[] quantiles(double[] qTiles) {
        Arrays.sort(qTiles);
        double[] ret = new double[qTiles.length];
        int tile = 0;
        double sum = 0.0;
        for (int i = 0; i < this.p.length; ++i) {
            if (!((sum += this.p[i]) >= qTiles[tile])) continue;
            ret[tile] = this.x[i];
            if (++tile == qTiles.length) break;
        }
        return ret;
    }

    public double getMean() {
        return StatUtils.mean((double[])this.data);
    }

    public double getMode() throws Exception {
        return this.x[this.modeIndex];
    }

    public static void main(String[] args) throws Exception {
        PrintStream stream = System.out;
        if (args.length > 1) {
            stream = new PrintStream(args[1]);
        }
        Integer skip = null;
        if (args.length > 2) {
            skip = new Integer(args[2]);
        }
        stream.println("Name,Mode,Mean,Low,Median,High");
        File file = new File(args[0]);
        double[] tiles = new double[]{0.05, 0.5, 0.95};
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                SummaryStats stats = new SummaryStats(f, 0.01, skip);
                double[] q = stats.quantiles(tiles);
                double mean = stats.getMean();
                double mode = stats.getMode();
                stream.printf("%s,%f,%f", f.getName(), mode, mean);
                for (int i = 0; i < tiles.length; ++i) {
                    stream.printf(",%f", q[i]);
                }
                stream.println();
            }
            stream.flush();
        } else {
            SummaryStats stats = new SummaryStats(file, 0.01, skip);
            double[] q = stats.quantiles(tiles);
            double mean = stats.getMean();
            double mode = stats.getMode();
            boolean bl = false;
        }
    }
}

