/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.rhwlab.DAG.pipeline.Demux;
import org.rhwlab.DAG.pipeline.KDE;
import org.rhwlab.DAG.pipeline.MCMC;

public class Pipeline
implements Runnable {
    public static boolean tracing = false;
    public static boolean dump = false;
    String name;
    Document doc;
    Element root;
    MCMC mcmc;

    public Pipeline(String xmlFile) throws Exception {
        this.name = xmlFile;
        SAXBuilder saxBuilder = new SAXBuilder();
        this.doc = saxBuilder.build(new File(xmlFile + ".xml"));
        this.root = this.doc.getRootElement();
    }

    @Override
    public void run() {
        try {
            for (Element processEle : this.root.getChildren()) {
                if (processEle.getName().equals("MCMC")) {
                    this.mcmc = new MCMC(this.name, processEle);
                    this.mcmc.run();
                    continue;
                }
                if (processEle.getName().equals("Demux")) {
                    Demux demux = new Demux(this.name, processEle);
                    demux.run();
                    continue;
                }
                if (processEle.getName().equals("KDE")) {
                    KDE kde = new KDE(this.name, processEle);
                    kde.run();
                    continue;
                }
                if (!processEle.getName().equals("Norm")) continue;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public MCMC getMCMC() throws Exception {
        Element mcmcEle = this.root.getChild("MCMC");
        this.mcmc = new MCMC(this.name, mcmcEle);
        return this.mcmc;
    }

    public static void main(String[] args) throws Exception {
        Pipeline pipe = new Pipeline(args[0]);
        pipe.run();
    }
}

