/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.rhwlab.DAG.pipeline.MCMC;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.DAG.pipeline.Utils;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;

public class NormalizeFeatures
implements Runnable {
    DataSource source;
    KdeFile[] kdeFiles;
    String outFile;

    public NormalizeFeatures() {
    }

    public NormalizeFeatures(DataSource source, KdeFile kde, String outFile) throws Exception {
        this.source = source;
        this.kdeFiles = new KdeFile[1];
        this.kdeFiles[0] = kde;
        this.outFile = outFile;
    }

    @Override
    public void run() {
        try {
            PrintStream writer = new PrintStream(this.outFile);
            for (KdeFile kde : this.kdeFiles) {
                for (String feature : kde.allPrefixes()) {
                    double[] stagedMode = kde.getValues(feature, "Mode");
                    double[] stagedLow = kde.getValues(feature, "Low");
                    double[] stagedHigh = kde.getValues(feature, "High");
                    double[] allDCPM = this.source.allFeatureData(feature);
                    double targetMu = StatUtils.mean((double[])allDCPM);
                    double targetSD = Math.sqrt(StatUtils.variance((double[])allDCPM, (double)targetMu));
                    double[][] norm = Utils.normalize(stagedMode, stagedLow, stagedHigh, targetMu, targetSD);
                    writer.printf("%s", feature);
                    for (int j = 0; j < norm[0].length; ++j) {
                        double low = norm[0][j];
                        if (low < 0.0) {
                            // empty if block
                        }
                        writer.printf(",%.4f(%.4f:%.4f)", norm[1][j], low, norm[2][j]);
                    }
                    writer.println();
                }
            }
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSource(Object obj) {
        this.source = (DataSource)obj;
    }

    public void setKDEFile(Object obj) {
        if (obj instanceof KdeFile[]) {
            this.kdeFiles = (KdeFile[])obj;
        } else if (obj instanceof KdeFile) {
            this.kdeFiles = new KdeFile[1];
            this.kdeFiles[0] = (KdeFile)obj;
        } else if (obj instanceof List) {
            List list = (List)obj;
            this.kdeFiles = new KdeFile[list.size()];
            int i = 0;
            for (Object o : list) {
                this.kdeFiles[i] = (KdeFile)o;
                ++i;
            }
        }
    }

    public void setOutFile(Object obj) {
        this.outFile = (String)obj;
    }

    public static void main(String[] args) throws Exception {
        Pipeline pipe = new Pipeline(args[0]);
        MCMC mcmc = pipe.getMCMC();
        KdeFile kde = new KdeFile(args[0] + ".kde");
        NormalizeFeatures norm = new NormalizeFeatures(mcmc.getDataSource(), kde, args[0] + ".norm");
        norm.run();
    }
}

