/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.PrintStream;
import java.util.Set;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.ExperimentDataSource;
import org.rhwlab.RNASeq.PMatrixKdeFile;

public class MutantN2Compare {
    public static void main(String[] args) throws Exception {
        PrintStream stream = System.out;
        if (args.length == 2) {
            stream = new PrintStream(args[1]);
        }
        stream.println("Gene,RMS_Error");
        UnifiedResult unified = new UnifiedResult();
        Pipeline pipe = new Pipeline(args[0]);
        DataSource dataSource = pipe.getMCMC().getDataSource();
        PMatrixKdeFile kde = pipe.getMCMC().getPKDE();
        String[] experiments = dataSource.getExperiments();
        Set<String> genes = unified.getGeneNames();
        for (String gene : genes) {
            for (String exp : experiments) {
                ExperimentDataSource expSource = dataSource.getExperimentSource(exp);
                double[] sampleTimes = expSource.getTimes();
                PMatrix pMatrix = new PMatrix(unified.getStageCount(), sampleTimes, exp, null, kde);
                double[] dcpm = expSource.getFeatureData(gene);
                double sum = 0.0;
                if (dcpm != null) {
                    for (int i = 0; i < dcpm.length; ++i) {
                        double time = pMatrix.getMean(i);
                        Double unifiedValue = unified.unifiedValue(gene, time);
                        double diff = dcpm[i] - unifiedValue;
                        sum += diff * diff;
                    }
                    sum = Math.sqrt(sum / (double)dcpm.length);
                }
                stream.printf("%s,%f\n", gene, sum);
            }
        }
    }
}

