/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.commons.math3.stat.StatUtils;
import weka.estimators.KernelEstimator;

public class MultiKDE
implements Runnable {
    String inFile;
    String outFile;
    double precision = 0.01;
    int skip = 0;
    TreeMap<String, double[]> dataMap;

    @Override
    public void run() {
        try {
            PrintStream stream = System.out;
            if (this.outFile != null) {
                stream = new PrintStream(this.outFile);
            }
            stream.println("Name,Mode,Mean,Low,Median,High");
            File file = new File(this.inFile);
            double[] tiles = new double[]{0.05, 0.5, 0.95};
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.dataMap = MultiKDE.readFile(f, this.skip);
                    this.report(stream, this.precision, tiles);
                }
            } else {
                this.dataMap = MultiKDE.readFile(file, this.skip);
                this.report(stream, this.precision, tiles);
            }
            stream.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void report(PrintStream stream, double precision, double[] qTiles) throws Exception {
        for (String name : this.dataMap.keySet()) {
            double[] data = this.dataMap.get(name);
            KernelEstimator estimator = this.kde(data, precision);
            PDF pdf = this.pdf(data, estimator);
            double[] quantiles = this.quantiles(pdf, qTiles);
            stream.printf("%s,%f,%f", name, pdf.mode, pdf.mean);
            for (int i = 0; i < quantiles.length; ++i) {
                stream.printf(",%f", quantiles[i]);
            }
            stream.println();
            stream.flush();
        }
    }

    public static TreeMap<String, double[]> readFile(File infile, Integer skip) throws Exception {
        int i;
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        String line = reader.readLine();
        String[] names = line.split(",");
        line = reader.readLine();
        if (skip != null) {
            for (int i2 = 1; i2 < skip; ++i2) {
                line = reader.readLine();
            }
        }
        ArrayList[] columns = new ArrayList[names.length];
        for (int i3 = 0; i3 < columns.length; ++i3) {
            columns[i3] = new ArrayList();
        }
        while (line != null) {
            String[] tokens = line.split(",");
            for (i = 0; i < tokens.length; ++i) {
                ArrayList col = columns[i];
                col.add(new Double(tokens[i]));
            }
            line = reader.readLine();
        }
        reader.close();
        TreeMap<String, double[]> ret = new TreeMap<String, double[]>();
        for (i = 0; i < names.length; ++i) {
            ArrayList list = columns[i];
            double[] data = new double[list.size()];
            for (int j = 0; j < data.length; ++j) {
                data[j] = (Double)list.get(j);
            }
            ret.put(names[i], data);
        }
        return ret;
    }

    private KernelEstimator kde(double[] data, double precision) throws Exception {
        KernelEstimator estimator = new KernelEstimator(precision);
        for (int i = 0; i < data.length; ++i) {
            estimator.addValue(data[i], 1.0);
        }
        return estimator;
    }

    private PDF pdf(double[] data, KernelEstimator kde) {
        int n = kde.getNumKernels();
        double[] x = kde.getMeans();
        double[] p = new double[n];
        double pTotal = 0.0;
        for (int i = 0; i < n; ++i) {
            p[i] = kde.getProbability(x[i]);
            pTotal += p[i];
        }
        double pMax = 0.0;
        int modeIndex = -1;
        for (int i = 0; i < n; ++i) {
            p[i] = p[i] / pTotal;
            if (!(p[i] > pMax)) continue;
            pMax = p[i];
            modeIndex = i;
        }
        PDF pdf = new PDF(x, p, x[modeIndex], StatUtils.mean((double[])data));
        return pdf;
    }

    public double[] quantiles(PDF pdf, double[] qTiles) {
        double[] x = pdf.x;
        double[] p = pdf.p;
        Arrays.sort(qTiles);
        double[] ret = new double[qTiles.length];
        int tile = 0;
        double sum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            if (!((sum += p[i]) >= qTiles[tile])) continue;
            ret[tile] = x[i];
            if (++tile == qTiles.length) break;
        }
        return ret;
    }

    public void setInFile(String file) {
        this.inFile = file;
    }

    public void setOutFile(String file) {
        this.outFile = file;
    }

    public void setPrecision(Double p) {
        this.precision = p;
    }

    public void setSkip(Integer s) {
        this.skip = s;
    }

    public static void main(String[] args) throws Exception {
        MultiKDE kde = new MultiKDE();
        kde.setInFile(args[0]);
        kde.setOutFile(args[1]);
        kde.setSkip(new Integer(args[2]));
    }

    public class PDF {
        double[] x;
        double[] p;
        double mode;
        double mean;

        public PDF(double[] x, double[] p, double mode, double mean) {
            this.x = x;
            this.p = p;
            this.mode = mode;
            this.mean = mean;
        }
    }
}

