/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.rhwlab.DAG.decomp.Config;
import org.rhwlab.DAG.decomp.Unification;
import org.rhwlab.DAG.models.ComponentWise;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;

public class MCMC
implements Runnable {
    String pipe;
    DataSource source;
    Config config;
    KdeFile zKDE = null;
    PMatrixKdeFile pKDE = null;
    List<String> variableList = null;

    public MCMC(String name, DataSource source, Config config, PMatrixKdeFile pKDE, List<String> variableList) {
        this.pipe = name;
        this.config = config;
        this.pKDE = pKDE;
        this.source = source;
        this.variableList = variableList;
    }

    public MCMC(String pipeName, Element root) throws Exception {
        String variablesFile;
        this.pipe = pipeName;
        Element sourceEle = root.getChild("DataSource");
        this.source = new DataSource(sourceEle);
        Element configEle = root.getChild("Config");
        this.config = new Config(configEle);
        Element zEle = root.getChild("ZKDE");
        this.zKDE = new KdeFile(zEle);
        Element pEle = root.getChild("PKDE");
        this.pKDE = new PMatrixKdeFile(pEle);
        Element varEle = root.getChild("Variables");
        if (varEle != null && (variablesFile = varEle.getAttributeValue("file")) != null) {
            this.variableList = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(variablesFile));
            String line = reader.readLine();
            while (line != null) {
                this.variableList.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
    }

    @Override
    public void run() {
        try {
            Unification uni = new Unification(this.config.getNStages(), this.source, this.zKDE, this.pKDE, this.variableList);
            uni.init();
            ComponentWise algorithm = new ComponentWise(uni);
            algorithm.setBurnIn(this.config.getBurnIn());
            algorithm.setIterations(this.config.getIterations());
            PrintStream stream = new PrintStream(this.pipe + ".jpd");
            uni.setRecordStream(stream);
            algorithm.run();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public Config getConfig() {
        return this.config;
    }

    public PMatrixKdeFile getPKDE() {
        return this.pKDE;
    }

    public void setZ(Object o) {
        this.zKDE = (KdeFile)o;
    }
}

