/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.File;
import java.io.PrintStream;
import org.jdom2.Element;
import org.rhwlab.DAG.pipeline.SummaryStats;

public class KDE
implements Runnable {
    File marginalDir = null;
    File outFile;
    double precision = 0.01;
    int skip = 0;

    public KDE() {
    }

    public KDE(String pipelineName, Element root) {
        Element margEle;
        String sk;
        String prec = root.getAttributeValue("precision");
        if (prec != null) {
            this.precision = Double.valueOf(prec);
        }
        if ((sk = root.getAttributeValue("skip")) != null) {
            this.skip = Integer.valueOf(sk);
        }
        if ((margEle = root.getChild("Marginals")) != null) {
            String dirName = margEle.getAttributeValue("file");
            if (dirName == null) {
                dirName = pipelineName + ".mpd";
            }
            this.marginalDir = new File(dirName);
        }
        this.outFile = new File(pipelineName + ".kde");
    }

    @Override
    public void run() {
        try {
            if (this.marginalDir != null) {
                File[] files;
                PrintStream stream = new PrintStream(this.outFile);
                stream.println("Name,Mode,Mean,Low,Median,High");
                double[] tiles = new double[]{0.05, 0.5, 0.95};
                for (File file : files = this.marginalDir.listFiles()) {
                    SummaryStats stats = new SummaryStats(file, this.precision, this.skip);
                    double[] q = stats.quantiles(tiles);
                    double mean = stats.getMean();
                    double mode = stats.getMode();
                    stream.printf("%s,%f,%f", file.getName(), mode, mean);
                    for (int i = 0; i < tiles.length; ++i) {
                        stream.printf(",%f", q[i]);
                    }
                    stream.println();
                }
                stream.flush();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setMarginals(String dir) {
        this.marginalDir = new File(dir + ".mpd");
        this.outFile = new File(dir + ".kde");
    }
}

