/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FeatureDemux {
    TreeMap<String, int[]> colMap = new TreeMap();
    TreeMap<String, List<double[]>> dataMap = new TreeMap();

    public FeatureDemux(Set<String> features, File dataFile) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
        String line = reader.readLine();
        reader.close();
        String[] variables = line.split(",");
        HashMap<String, Integer> varColumnMap = new HashMap<String, Integer>();
        for (int v = 0; v < variables.length; ++v) {
            varColumnMap.put(variables[v], new Integer(v));
        }
        TreeMap<String, ArrayList<String>> featureVarMap = new TreeMap<String, ArrayList<String>>();
        for (String feature : features) {
            if (feature.equals("2L52.1")) {
                boolean bl = false;
            }
            boolean found = false;
            for (int v = 0; v < variables.length; ++v) {
                String var = variables[v];
                if (!var.startsWith(feature + "_")) continue;
                ArrayList<String> varList = (ArrayList<String>)featureVarMap.get(feature);
                if (varList == null) {
                    varList = new ArrayList<String>();
                    featureVarMap.put(feature, varList);
                }
                varList.add(var);
                found = true;
            }
            if (found) continue;
            System.out.printf("Feature %s not found\n", feature);
        }
        for (String feature : featureVarMap.keySet()) {
            PrintWriter writer = new PrintWriter(new FileWriter(new File(feature)));
            List varList = (List)featureVarMap.get(feature);
            int[] cols = new int[varList.size()];
            for (int i = 0; i < varList.size(); ++i) {
                String var = (String)varList.get(i);
                cols[i] = (Integer)varColumnMap.get(var);
                if (i > 0) {
                    writer.print(",");
                }
                writer.print(var);
            }
            writer.println();
            this.colMap.put(feature, cols);
            this.dataMap.put(feature, new ArrayList());
            writer.close();
        }
    }

    public void demux(File dataFile) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(dataFile));
        String line = reader.readLine();
        line = reader.readLine();
        int count = 0;
        while (line != null) {
            String[] tokens = line.split(",");
            for (String feature : this.colMap.keySet()) {
                List<double[]> dataList = this.dataMap.get(feature);
                int[] cols = this.colMap.get(feature);
                double[] data = new double[cols.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = Double.valueOf(tokens[cols[i]]);
                }
                dataList.add(data);
                if (count != 100) continue;
                count = 0;
                this.flushData();
            }
            ++count;
            line = reader.readLine();
        }
        this.flushData();
        reader.close();
    }

    private void flushData() throws Exception {
        for (String feature : this.dataMap.keySet()) {
            PrintWriter writer = new PrintWriter(new FileWriter(new File(feature), true));
            List<double[]> dataList = this.dataMap.get(feature);
            for (double[] data : dataList) {
                writer.printf("%.6f", data[0]);
                for (int i = 1; i < data.length; ++i) {
                    writer.printf(",%.6f", data[i]);
                }
                writer.println();
            }
            this.dataMap.put(feature, new ArrayList());
            writer.close();
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        TreeSet<String> featureSet = new TreeSet<String>();
        String line = reader.readLine();
        while (line != null) {
            String[] features = line.split(" ");
            String feature = features[0];
            featureSet.add(feature);
            line = reader.readLine();
        }
        File dataFile = new File(args[1]);
        FeatureDemux demux = new FeatureDemux(featureSet, dataFile);
        demux.demux(dataFile);
    }
}

