/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.pipeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Element;

public class Demux
implements Runnable {
    String jpdFile;
    int n = 1000;
    int count;
    File dir;
    BufferedReader reader;
    String[] vars;
    double[][] data;
    Set<String> varsToDoSet = null;

    public Demux() {
    }

    public Demux(String pipelineName, Element root) throws Exception {
        String varListFile;
        Element varEle;
        String lines = root.getAttributeValue("lines");
        if (lines != null) {
            this.n = Integer.valueOf(lines);
        }
        if ((varEle = root.getChild("Variables")) != null && (varListFile = varEle.getAttributeValue("file")) != null) {
            this.setVariablesFile(varListFile);
        }
        this.jpdFile = pipelineName;
        this.init();
    }

    public void init() throws Exception {
        this.reader = new BufferedReader(new FileReader(this.jpdFile + ".jpd"));
        String line = this.reader.readLine();
        this.vars = line.split(",");
        this.data = new double[this.vars.length][];
        for (int i = 0; i < this.vars.length; ++i) {
            this.data[i] = new double[this.n];
        }
        this.dir = new File(this.jpdFile + ".mpd");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        } else if (this.dir.isDirectory()) {
            File[] files;
            for (File file : files = this.dir.listFiles()) {
                file.delete();
            }
        } else {
            this.dir.delete();
            this.dir.mkdir();
        }
    }

    @Override
    public void run() {
        try {
            boolean eof;
            do {
                eof = this.readLines();
                this.dump();
            } while (!eof);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean readLines() throws Exception {
        this.count = 0;
        String line = this.reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                this.data[i][this.count] = tokens[i].equalsIgnoreCase("NA") ? Double.NaN : Double.valueOf(tokens[i]);
            }
            ++this.count;
            if (this.count == this.n) {
                return false;
            }
            line = this.reader.readLine();
        }
        return true;
    }

    public void dump() throws Exception {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.varsToDoSet != null && !this.varsToDoSet.contains(this.vars[i])) continue;
            File outFile = new File(this.dir, this.vars[i]);
            PrintStream stream = new PrintStream(new FileOutputStream(outFile, true));
            for (int j = 0; j < this.count; ++j) {
                stream.println(this.data[i][j]);
            }
            stream.close();
        }
    }

    private void readVarSet(String file) throws Exception {
        BufferedReader varreader = new BufferedReader(new FileReader(file));
        String line = varreader.readLine();
        while (line != null) {
            this.varsToDoSet.add(line);
            line = varreader.readLine();
        }
        varreader.close();
    }

    public void setJPDFile(String file) {
        this.jpdFile = file;
    }

    public void setVariablesFile(String file) throws Exception {
        this.varsToDoSet = new HashSet<String>();
        this.readVarSet(file);
    }
}

