/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.parameters;

import java.io.PrintStream;
import org.rhwlab.DAG.Parameter;
import org.rhwlab.DAG.ScalarParameter;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.proposal.BoundedRandomWalk;

public class NonNegative
extends ScalarParameter {
    double proposalSD;

    public NonNegative(String name, Model model, double proposalSD, double initial) {
        super(name, model);
        this.proposalSD = proposalSD;
        BoundedRandomWalk rwm = new BoundedRandomWalk();
        rwm.setSigma(proposalSD);
        rwm.setLowerBound(0.0);
        rwm.setUpperBound(Double.POSITIVE_INFINITY);
        this.setProposal(rwm);
        if (initial >= 0.0) {
            this.setValue(initial);
        } else {
            this.setValue(rwm.sample(0.0));
        }
    }

    public NonNegative(String name, Model model, double proposalSD) {
        this(name, model, proposalSD, -1.0);
    }

    @Override
    public Parameter copy(Model toModel) {
        return new NonNegative(this.getName(), toModel, this.proposalSD, (Double)this.getValue());
    }

    @Override
    public void reportValue(PrintStream stream, boolean first) {
        if (!first) {
            stream.print(",");
        }
        stream.printf("%.4f", (Double)this.getValue());
    }

    @Override
    public void dump(PrintStream stream) {
        stream.println(this.getName());
        this.reportValue(stream, true);
    }

    public static void main(String[] args) throws Exception {
        PrintStream stream = new PrintStream("/net/waterston/vol2/home/gevirl/random");
        NonNegative param = new NonNegative("Test", null, 100.0);
        int n = Integer.parseInt(args[0]);
        for (int i = 0; i < n; ++i) {
            double r = (Double)param.propose();
            stream.printf("%f\n", (Double)param.getValue(), r);
        }
    }
}

