/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.parameters;

import java.io.PrintStream;
import org.rhwlab.DAG.Parameter;
import org.rhwlab.DAG.distributions.MultiVariate;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.proposal.ProposalDistribution;

public class MultiVariateParameter
extends Parameter {
    Integer N = null;

    @Override
    public void setProposal(ProposalDistribution dist) {
        super.setProposal(dist);
        this.N = ((MultiVariate)((Object)dist)).getN();
    }

    public void setNumberOfVariables(Integer n) {
        this.N = n;
    }

    public int getNumberOfVariables() {
        return this.N;
    }

    @Override
    public final void setName(String s) {
        super.setName(s);
        this.buildCompositeName();
    }

    public void buildCompositeName() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%s_MVN_0", this.getName()));
        for (int i = 1; i < this.N; ++i) {
            builder.append(String.format(",%s_MVN_%d", this.getName(), i));
        }
        super.setName(builder.toString());
    }

    @Override
    public Parameter copy(Model model) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void reportValue(PrintStream stream, boolean first) {
        if (!first) {
            stream.print(",");
        }
        double[] v = (double[])this.getValue();
        stream.printf("%.4f", v[0]);
        for (int i = 1; i < v.length; ++i) {
            stream.printf(",%.4f", v[i]);
        }
    }

    @Override
    public void dump(PrintStream stream) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

