/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.parameters;

import org.rhwlab.DAG.parameters.MultiVariateParameter;
import org.rhwlab.DAG.proposal.BoundedMultiRandomWalk;

public class DirichletRandomWalkParameter
extends MultiVariateParameter {
    Double sigma = null;

    @Override
    public Object propose() {
        int i;
        double[] ret = new double[this.N.intValue()];
        double[] proposal = (double[])super.propose();
        double sum = 0.0;
        for (i = 0; i < proposal.length; ++i) {
            sum += proposal[i];
        }
        for (i = 0; i < proposal.length; ++i) {
            ret[i] = proposal[i];
        }
        ret[this.N.intValue() - 1] = 1.0 - sum;
        return ret;
    }

    @Override
    public void setNumberOfVariables(Integer n) {
        super.setNumberOfVariables(n);
        this.buildProposel();
    }

    public void setSigma(Double s) {
        this.sigma = s;
        if (this.buildProposel()) {
            this.init();
        }
    }

    private boolean buildProposel() {
        if (this.N != null && this.sigma != null) {
            BoundedMultiRandomWalk walk = new BoundedMultiRandomWalk();
            walk.setLowerBound(0.0);
            walk.setUpperBound(1.0);
            walk.setSigma(this.sigma);
            walk.setN(this.N - 1);
            this.setProposal(walk);
            return true;
        }
        return false;
    }

    private void init() {
        double[] v = new double[this.N.intValue()];
        for (int i = 0; i < this.N; ++i) {
            v[i] = 1.0 / (double)this.N.intValue();
        }
        this.setValue(v);
    }
}

