/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets.views;

import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.data.Range;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.DAG.onsets.LineageChangePointModel;
import org.rhwlab.DAG.onsets.views.DirichletLeafView;
import org.rhwlab.beans.EmbryoCell;

public class ModelView
extends JPanel
implements ChangeListener {
    ReversibleJump alg;
    Map<String, DirichletLeafView> viewMap;

    public ModelView(ReversibleJump alg, double minExp) {
        EmbryoCell[] leaves;
        this.alg = alg;
        alg.addListener(this);
        this.viewMap = new TreeMap<String, DirichletLeafView>();
        this.setLayout(new BoxLayout(this, 1));
        LineageChangePointModel model = (LineageChangePointModel)alg.getModel();
        for (EmbryoCell leafCell : leaves = model.getLeaves()) {
            String leafName = leafCell.getName();
            DirichletLeafView leafView = new DirichletLeafView(leafName, model.getLeafTimeSeries(leafName), minExp);
            leafView.useSegments(model.getSegments(leafName));
            this.add(leafView.getPanel());
            this.viewMap.put(leafName, leafView);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        LineageChangePointModel model = (LineageChangePointModel)this.alg.getModel();
        for (String leaf : this.viewMap.keySet()) {
            DirichletLeafView view = this.viewMap.get(leaf);
            view.useSegments(model.getSegments(leaf));
        }
    }

    public Range getRange() {
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        for (DirichletLeafView view : this.viewMap.values()) {
            Range r = view.getRange();
            double l = r.getLowerBound();
            double u = r.getUpperBound();
            if (l < xMin) {
                xMin = l;
            }
            if (!(u > xMax)) continue;
            xMax = u;
        }
        return new Range(xMin, xMax);
    }
}

