/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets.views;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.changepoints.TreeChangePoint;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.expression.TimeSeries;

public class LeafView {
    ExpressionTimeSeries timeSeries;
    EmbryoCell leaf;
    double yMin;
    double yMax;
    double[] y;
    JFreeChart chart;
    JPanel panel;
    XYSeriesCollection collect;
    XYSeries segSeries = null;
    XYLineAndShapeRenderer rend;
    XYPlot plot;
    boolean logSpace;
    boolean fixedScale;
    boolean onsetOnly;
    double minExp;
    double maxExp;

    public LeafView(boolean logSpace, boolean fixedScale, boolean onsetOnly, EmbryoCell leaf, ExpressionTimeSeries timeSeries, double minExp, double maxExp) {
        this.minExp = minExp;
        this.maxExp = maxExp;
        this.logSpace = logSpace;
        this.fixedScale = fixedScale;
        this.onsetOnly = onsetOnly;
        this.leaf = leaf;
        this.timeSeries = timeSeries;
        this.y = logSpace ? timeSeries.getLogAll(minExp) : timeSeries.getAllDouble();
        this.collect = new XYSeriesCollection();
        this.chart = ChartFactory.createXYLineChart((String)leaf.getName(), (String)"Time", (String)"Expression", (XYDataset)this.collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.panel = new ChartPanel(this.chart);
        this.drawTimeSeries();
    }

    private final void drawTimeSeries() {
        int i;
        XYSeries xyTimeSeries = new XYSeries((Comparable)((Object)"TimeSeries"));
        this.yMin = Double.MAX_VALUE;
        this.yMax = Double.MIN_VALUE;
        for (i = 0; i < this.y.length; ++i) {
            xyTimeSeries.add((double)i, this.y[i]);
            if (this.y[i] > this.yMax) {
                this.yMax = this.y[i];
            }
            if (!(this.y[i] < this.yMin)) continue;
            this.yMin = this.y[i];
        }
        if (this.yMin == 0.0) {
            i = 0;
        }
        this.collect.addSeries(xyTimeSeries);
        int loc = 0;
        for (int i2 = 0; i2 < this.timeSeries.getSeriesCount(); ++i2) {
            TimeSeries ts = this.timeSeries.getSeries(i2);
            XYSeries cellMark = new XYSeries((Comparable)((Object)ts.getLabel()));
            cellMark.add((double)loc, this.yMin);
            cellMark.add((double)loc, this.yMax);
            loc += ts.size();
            this.collect.addSeries(cellMark);
        }
        this.plot = this.chart.getXYPlot();
        this.setAxis();
        this.rend = new XYLineAndShapeRenderer();
        this.plot.setRenderer((XYItemRenderer)this.rend);
        int s = this.collect.indexOf(xyTimeSeries);
        this.rend.setSeriesLinesVisible(s, false);
        this.rend.setSeriesShapesVisible(s, true);
        this.rend.setSeriesPaint(s, (Paint)Color.black);
        Rectangle2D.Double shape = (Rectangle2D.Double)this.rend.getBaseShape();
        shape.height = 3.0;
        shape.width = 3.0;
        this.rend.setSeriesShape(s, (Shape)shape, true);
    }

    public final void useSegments(CP_Segment[] segments) {
        if (this.leaf.getName().equals("MSppppa")) {
            boolean bl = false;
        }
        try {
            this.collect.removeSeries(this.collect.getSeries((Comparable)((Object)"Segment")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List annot = this.plot.getAnnotations();
        for (Object a : annot) {
            this.plot.removeAnnotation((XYAnnotation)a);
        }
        if (segments.length > 1 && (!this.onsetOnly || TreeChangePoint.segmentsHaveOnset(segments))) {
            this.segSeries = new XYSeries((Comparable)((Object)"Segment"));
            for (int j = 0; j < segments.length; ++j) {
                CP_Segment seg = segments[j];
                for (int i = seg.getStart(); i < seg.getEnd(); ++i) {
                    double v = seg.getValue(i);
                    if (v > this.yMax) {
                        this.yMax = v;
                    }
                    if (v < this.yMin) {
                        this.yMin = v;
                    }
                    this.segSeries.add((double)i, v);
                }
            }
            double annLoc = this.yMin + 0.9 * (this.yMax - this.yMin);
            for (int j = 0; j < segments.length - 1; ++j) {
                CP_Segment seg = segments[j];
                if (j != segments.length - 1) {
                    XYTextAnnotation ann = new XYTextAnnotation(String.format("%d(%s-%.0f)", seg.getEnd(), seg.getChangePoint().getCell(), seg.getChangePoint().getTime()), (double)seg.getEnd(), annLoc);
                    this.plot.addAnnotation((XYAnnotation)ann);
                }
                XYSeries xYSeries = new XYSeries((Comparable)((Object)"ChangePoint"));
            }
            this.setAxis();
            this.collect.addSeries(this.segSeries);
            int s = this.collect.indexOf(this.segSeries);
            this.rend.setSeriesLinesVisible(s, true);
            this.rend.setSeriesShapesVisible(s, false);
            this.rend.setSeriesPaint(s, (Paint)Color.red);
            Stroke stoke = this.rend.getSeriesStroke(s);
            boolean bl = false;
        }
    }

    private void setAxis() {
        ValueAxis yAxis = this.plot.getRangeAxis();
        if (this.fixedScale) {
            if (this.logSpace) {
                yAxis.setLowerBound(this.yMin);
                yAxis.setUpperBound(Math.log(this.maxExp - this.minExp));
            } else {
                yAxis.setLowerBound(this.minExp);
                yAxis.setUpperBound(this.maxExp);
            }
        } else {
            yAxis.setLowerBound(this.yMin);
            yAxis.setUpperBound(this.yMax);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double[] getExpression() {
        return this.y;
    }

    public void setAxis(Range range) {
        ValueAxis axis = this.plot.getRangeAxis();
        if (range != null) {
            axis.setRange(range);
        } else {
            axis.setRange(new Range(this.yMin, this.yMax));
        }
    }

    public Range getRange() {
        return new Range(this.yMin, this.yMax);
    }

    public EmbryoCell getLeaf() {
        return this.leaf;
    }
}

