/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jfree.data.Range;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.multiembryo.MultiEmbryoResults;
import org.rhwlab.DAG.onsets.EmbryoChangePointResults;
import org.rhwlab.DAG.onsets.ResultStats;
import org.rhwlab.DAG.onsets.views.LeafView;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionTimeSeries;

public class EmbryoChangePointPanel
extends JPanel {
    Range range;
    SeriesEmbryo embryo;
    EmbryoCell[] leaves;
    JPanel leavesPanel;
    JScrollPane scroll;
    Map<String, LeafView> leafViewMap = new TreeMap<String, LeafView>();
    JTextField threshField;
    JCheckBox onsetBox;
    JCheckBox rangeBox;

    public EmbryoChangePointPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.leavesPanel = new JPanel();
        this.leavesPanel.setLayout(new BoxLayout(this.leavesPanel, 1));
        this.scroll = new JScrollPane(this.leavesPanel);
        this.add((Component)this.scroll, "Center");
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 0));
        displayPanel.add(new JLabel("Probability Threshold:  "));
        this.threshField = new JTextField("0.9");
        displayPanel.add(this.threshField);
        this.add((Component)displayPanel, "North");
        this.threshField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EmbryoChangePointPanel.this.useThreshold();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        this.onsetBox = new JCheckBox("Show onsets only");
        displayPanel.add(this.onsetBox);
        displayPanel.add(Box.createHorizontalStrut(30));
        this.rangeBox = new JCheckBox("Constant range");
        displayPanel.add(this.rangeBox);
    }

    public void useEmbryo(SeriesEmbryo embryo) throws Exception {
        this.embryo = embryo;
        this.leaves = embryo.getAllLeaves();
        this.leavesPanel.removeAll();
        for (EmbryoCell leaf : this.leaves) {
            ExpressionTimeSeries timeSeries = ExpressionTimeSeries.factory((EmbryoCell)leaf);
            LeafView view = new LeafView(true, true, false, leaf, timeSeries, embryo.minExpression(), embryo.maxExpression());
            this.leafViewMap.put(leaf.getName(), view);
            this.leavesPanel.add(view.getPanel());
        }
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        for (LeafView view : this.leafViewMap.values()) {
            Range r = view.getRange();
            double l = r.getLowerBound();
            double u = r.getUpperBound();
            if (l < xMin && l > 0.0) {
                xMin = l;
            }
            if (!(u > xMax)) continue;
            xMax = u;
        }
        this.range = new Range(xMin, xMax);
        this.useThreshold();
    }

    private void useThreshold() throws Exception {
        double thresh = Double.valueOf(this.threshField.getText());
        Map<String, ResultStats> results = MultiEmbryoResults.getChangePointsFromDB(this.embryo.getID(), thresh);
        if (this.onsetBox.isSelected()) {
            TreeMap<String, ResultStats> onsetMap = new TreeMap<String, ResultStats>();
            EmbryoCell[] embryoCellArray = this.embryo.getRoots();
            int n = embryoCellArray.length;
            for (int i = 0; i < n; ++i) {
                EmbryoCell root = embryoCellArray[i];
                onsetMap.putAll(EmbryoChangePointResults.ChangePointsToOnsets(this.range.getLowerBound(), root, results));
            }
            results = onsetMap;
        }
        for (EmbryoCell leaf : this.leaves) {
            LeafView view = this.leafViewMap.get(leaf.getName());
            CP_Segment[] segments = CP_Segment.factory(view.getExpression(), leaf, results);
            view.useSegments(segments);
            if (this.rangeBox.isSelected()) {
                view.setAxis(this.range);
                continue;
            }
            view.setAxis(null);
        }
    }
}

