/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets.views;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.onsets.ChangePointSegment;
import org.rhwlab.expression.ExpressionTimeSeries;
import org.rhwlab.expression.TimeSeries;

public class DirichletLeafView {
    double yMin;
    double yMax;
    int seriesMax;
    double[] y;
    JPanel panel;
    XYSeriesCollection collect;
    XYSeries segSeries = null;
    XYLineAndShapeRenderer rend;
    XYPlot plot;

    public DirichletLeafView(String leaf, ExpressionTimeSeries timeSeries, double minExp) {
        int i;
        boolean bl;
        if (leaf.equals("MSpaapap")) {
            bl = false;
        }
        if (leaf.equals("MSpaapaa")) {
            bl = false;
        }
        this.seriesMax = timeSeries.getMax();
        this.collect = new XYSeriesCollection();
        XYSeries xyTimeSeries = new XYSeries((Comparable)((Object)"TimeSeries"));
        this.y = timeSeries.getLogAll(minExp);
        this.yMin = Double.MAX_VALUE;
        this.yMax = Double.MIN_VALUE;
        for (i = 0; i < this.y.length; ++i) {
            xyTimeSeries.add((double)i, this.y[i]);
            if (this.y[i] > this.yMax) {
                this.yMax = this.y[i];
            }
            if (!(this.y[i] < this.yMin)) continue;
            this.yMin = this.y[i];
        }
        if (this.yMin == 0.0) {
            i = 0;
        }
        this.collect.addSeries(xyTimeSeries);
        int loc = 0;
        for (int i2 = 0; i2 < timeSeries.getSeriesCount(); ++i2) {
            TimeSeries ts = timeSeries.getSeries(i2);
            XYSeries cellMark = new XYSeries((Comparable)((Object)ts.getLabel()));
            cellMark.add((double)loc, this.yMin);
            cellMark.add((double)loc, this.yMax);
            loc += ts.size();
            this.collect.addSeries(cellMark);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)leaf, (String)"Time", (String)"Expression", (XYDataset)this.collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        this.plot = chart.getXYPlot();
        ValueAxis yAxis = this.plot.getRangeAxis();
        yAxis.setLowerBound(this.yMin);
        this.rend = new XYLineAndShapeRenderer();
        this.plot.setRenderer((XYItemRenderer)this.rend);
        int s = this.collect.indexOf(xyTimeSeries);
        this.rend.setSeriesLinesVisible(s, false);
        this.rend.setSeriesShapesVisible(s, true);
        this.rend.setSeriesPaint(s, (Paint)Color.black);
        Rectangle2D.Double shape = (Rectangle2D.Double)this.rend.getBaseShape();
        shape.height = 3.0;
        shape.width = 3.0;
        this.rend.setSeriesShape(s, (Shape)shape, true);
        this.panel = new ChartPanel(chart);
    }

    public final void useSegments(ChangePointSegment[] segments) {
        try {
            this.collect.removeSeries(this.collect.getSeries((Comparable)((Object)"Segment")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List annot = this.plot.getAnnotations();
        for (Object a : annot) {
            this.plot.removeAnnotation((XYAnnotation)a);
        }
        if (segments.length > 1) {
            this.segSeries = new XYSeries((Comparable)((Object)"Segment"));
            for (int j = 0; j < segments.length; ++j) {
                ChangePointSegment seg = segments[j];
                if (j > 0) {
                    XYTextAnnotation ann = new XYTextAnnotation(String.format("%d", seg.getStart()), (double)seg.getStart(), Math.log(0.9 * (double)this.seriesMax));
                    this.plot.addAnnotation((XYAnnotation)ann);
                }
                for (int i = seg.getStart(); i <= seg.getEnd(); ++i) {
                    double v = seg.getValue(i);
                    this.segSeries.add((double)i, v);
                }
            }
            this.collect.addSeries(this.segSeries);
            int s = this.collect.indexOf(this.segSeries);
            this.rend.setSeriesLinesVisible(s, true);
            this.rend.setSeriesShapesVisible(s, false);
            this.rend.setSeriesPaint(s, (Paint)Color.red);
            Stroke stoke = this.rend.getSeriesStroke(s);
            boolean bl = false;
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double[] getExpression() {
        return this.y;
    }

    public void setAxis(Range range) {
        ValueAxis axis = this.plot.getRangeAxis();
        if (range != null) {
            axis.setRange(range);
        } else {
            axis.setRange(new Range(this.yMin, this.yMax));
        }
    }

    public Range getRange() {
        return new Range(this.yMin, this.yMax);
    }
}

