/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.DAG.Data;
import org.rhwlab.DAG.changepoints.Count;
import org.rhwlab.DAG.distributions.InverseGamma;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.models.ReversibleJumpModel;
import org.rhwlab.DAG.onsets.ChangePointParameter;
import org.rhwlab.DAG.onsets.ChangePointSegment;
import org.rhwlab.DAG.onsets.LeafDataLikelihood;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.expression.ExpressionTimeSeries;

public class LineageChangePointModel
extends ReversibleJumpModel {
    String choice;
    EmbryoCell targetLeaf;
    EmbryoCell lineageRoot;
    TreeSet<EmbryoCell> lineageCells;
    EmbryoCell[] leaves;
    SeriesEmbryo embryo;
    Map<String, ExpressionTimeSeries> leafTimeSeriesMap;
    static String[] jumps = new String[]{"Add", "Del", "Chg"};
    static Random rand = null;
    NonNegative sigma;
    Map<String, ChangePointParameter> changePointMap;
    TreeMap<String, LeafDataLikelihood> likelihoodMap;
    boolean first = true;
    PrintStream stream;

    public LineageChangePointModel(SeriesEmbryo embryo, EmbryoCell lineage) throws Exception {
        this.embryo = embryo;
        this.stream = new PrintStream(lineage.getName());
        if (rand == null) {
            rand = new Random();
        }
        this.lineageRoot = lineage;
        this.lineageCells = lineage.getAllCells();
        String sigmaName = "Sigma_" + this.lineageRoot.getName();
        this.stream.print(sigmaName);
        for (EmbryoCell cell : this.lineageCells) {
            this.stream.printf(",%s", cell.getName());
        }
        this.stream.println();
        this.leaves = lineage.getLeaves();
        this.leafTimeSeriesMap = new HashMap<String, ExpressionTimeSeries>();
        for (EmbryoCell leaf : this.leaves) {
            this.leafTimeSeriesMap.put(leaf.getName(), ExpressionTimeSeries.factory((EmbryoCell)leaf));
        }
        this.changePointMap = new TreeMap<String, ChangePointParameter>();
        this.sigma = new NonNegative(sigmaName, this, 0.2, 1.0);
        this.sigma.setPrior(new InverseGamma(1.0, 1.0));
        this.likelihoodMap = new TreeMap();
        this.constructLikelihoods();
    }

    public LineageChangePointModel(SeriesEmbryo embryo, PrintStream stream, EmbryoCell lineage, EmbryoCell[] leaves, TreeSet<EmbryoCell> lineageCells, Map leafTimeSeriesMap, NonNegative sigma) {
        this.embryo = embryo;
        this.stream = stream;
        this.lineageRoot = lineage;
        this.leaves = leaves;
        this.leafTimeSeriesMap = leafTimeSeriesMap;
        this.lineageCells = lineageCells;
        this.changePointMap = new TreeMap<String, ChangePointParameter>();
        this.sigma = (NonNegative)sigma.copy(this);
        sigma.setPrior(new InverseGamma(1.0, 1.0));
        this.likelihoodMap = new TreeMap();
    }

    @Override
    public ReversibleJumpModel propose() {
        this.targetLeaf = this.leaves[rand.nextInt(this.leaves.length)];
        LeafDataLikelihood likelihood = this.likelihoodMap.get(this.targetLeaf.getName());
        ArrayList<ChangePointParameter> leafChangePoints = likelihood.getLeafChangePoints();
        this.choice = "Add";
        if (!leafChangePoints.isEmpty()) {
            this.choice = jumps[rand.nextInt(jumps.length)];
        }
        LineageChangePointModel nextModel = new LineageChangePointModel(this.embryo, this.stream, this.lineageRoot, this.leaves, this.lineageCells, this.leafTimeSeriesMap, this.sigma);
        nextModel.targetLeaf = this.targetLeaf;
        nextModel.choice = this.choice;
        for (ChangePointParameter cp : this.changePointMap.values()) {
            boolean found = false;
            for (int i = 0; i < leafChangePoints.size(); ++i) {
                if (!((ChangePointParameter)leafChangePoints.get(i)).getName().equals(cp.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            cp.copy(nextModel);
        }
        int n = leafChangePoints.size();
        if (this.choice.equals("Add")) {
            ++n;
        } else if (this.choice.equals("Del")) {
            --n;
        }
        ArrayList ancestors = this.targetLeaf.getAncestorsInclusive();
        n = Math.min(n, ancestors.size());
        int count = 0;
        while (count < n) {
            ChangePointParameter cp;
            int j = rand.nextInt(ancestors.size());
            EmbryoCell ancestor = (EmbryoCell)ancestors.get(j);
            if (!ancestor.isLeaf()) {
                cp = new ChangePointParameter(ancestor, nextModel);
                ancestors.remove(j);
                ++count;
                continue;
            }
            if (ancestor.getEndTime() - ancestor.getStartTime() <= 15) continue;
            cp = new ChangePointParameter(ancestor, nextModel, 15);
            ancestors.remove(j);
            ++count;
        }
        nextModel.constructLikelihoods();
        Collection ps = nextModel.getParameters();
        return nextModel;
    }

    private void constructLikelihoods() {
        for (EmbryoCell leaf : this.leaves) {
            String leafName = leaf.getName();
            double[] y = this.leafTimeSeriesMap.get(leafName).getLogAll((double)this.embryo.minExpression());
            LeafDataLikelihood like = new LeafDataLikelihood(this.changePointMap, leaf, y, this.sigma);
            this.likelihoodMap.put(leafName, like);
            Data dataNode = new Data(leafName, this.changePointMap, (Model)this, like);
            dataNode.addParent(this.sigma);
            ArrayList<ChangePointParameter> cps = this.getLeafChangePoints(leaf.getName());
            for (ChangePointParameter cp : cps) {
                dataNode.addParent(cp);
            }
        }
        for (EmbryoCell leaf : this.leaves) {
            ArrayList<ChangePointParameter> cps = this.getLeafChangePoints(leaf.getName());
            Count count = cps == null ? new Count("Count", (Model)this, 0) : new Count("Count", (Model)this, cps.size());
        }
    }

    @Override
    public double logProposal(ReversibleJumpModel next) {
        double p = 0.0;
        if (!this.getLeafChangePoints(this.targetLeaf.getName()).isEmpty()) {
            p = -Math.log(3.0);
        }
        LineageChangePointModel nextModel = (LineageChangePointModel)next;
        ArrayList<ChangePointParameter> cps = nextModel.getLeafChangePoints(this.targetLeaf.getName());
        int n = this.targetLeaf.getAncestorsInclusive().size();
        for (ChangePointParameter cp : cps) {
            EmbryoCell cell = cp.cell;
            int range = 1 + cell.getEndTime() - cell.getStartTime();
            if (cell.isLeaf()) {
                range -= 15;
            }
            p = p - Math.log(n) - Math.log(range);
            --n;
        }
        return p;
    }

    @Override
    public String getModelID() {
        StringBuilder builder = new StringBuilder();
        for (ChangePointParameter cp : this.changePointMap.values()) {
            builder.append(":");
            builder.append(cp.getName());
        }
        return String.format("%s%d:%d", this.lineageRoot.getName(), this.changePointMap.size(), builder.toString().hashCode());
    }

    public EmbryoCell getLineage() {
        return this.lineageRoot;
    }

    public ExpressionTimeSeries getLeafTimeSeries(String leaf) {
        return this.leafTimeSeriesMap.get(leaf);
    }

    public ArrayList<ChangePointParameter> getLeafChangePoints(String leaf) {
        LeafDataLikelihood like = this.likelihoodMap.get(leaf);
        ArrayList<ChangePointParameter> cps = like.getLeafChangePoints();
        return cps;
    }

    @Override
    public void record() {
        this.stream.printf("%.4f", (Double)this.sigma.getValue());
        for (EmbryoCell cell : this.lineageCells) {
            ChangePointParameter cp = this.changePointMap.get(cell.getName());
            if (cp != null) {
                this.stream.printf(",%.4f", (Double)cp.getValue());
                continue;
            }
            this.stream.print(",NA");
        }
        this.stream.println();
    }

    public EmbryoCell[] getLeaves() {
        return this.leaves;
    }

    public ChangePointSegment[] getSegments(String leaf) {
        return this.likelihoodMap.get(leaf).getSegments();
    }

    public String getMove() {
        return String.format("%s %s", this.choice, this.targetLeaf.getName());
    }
}

