/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets;

import java.util.ArrayList;
import java.util.Map;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.onsets.ChangePointParameter;
import org.rhwlab.DAG.onsets.ChangePointSegment;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;

public class LeafDataLikelihood
implements Distribution {
    ChangePointSegment[] segments;
    NonNegative variance;
    Map<String, ChangePointParameter> cpMap;
    double[] y;
    ArrayList<ChangePointParameter> cpList;
    static double minusBeta = Math.log(0.5) / 0.05;

    public LeafDataLikelihood(Map<String, ChangePointParameter> o, EmbryoCell leaf, double[] y, NonNegative variance) {
        this.cpMap = o;
        this.variance = variance;
        this.y = y;
        this.cpList = this.getAncestorChangePoints(leaf);
    }

    private ArrayList<ChangePointParameter> getAncestorChangePoints(EmbryoCell cell) {
        EmbryoCell parent = cell.getParentCell();
        ArrayList<ChangePointParameter> ret = parent != null ? this.getAncestorChangePoints(parent) : new ArrayList();
        ChangePointParameter cp = this.cpMap.get(cell.getName());
        if (cp != null) {
            ret.add(cp);
        }
        return ret;
    }

    @Override
    public Object sample() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double[] dirichlet = ChangePointSegment.dirichletFromCPs(this.cpList, this.y);
        this.segments = ChangePointSegment.factory(this.y, dirichlet);
        double p = 0.0;
        double sig = (Double)this.variance.getValue();
        for (ChangePointSegment seg : this.segments) {
            for (int i = seg.getStart(); i <= seg.getEnd(); ++i) {
                p += Normal.logDensity(this.y[i], seg.getValue(i), sig);
            }
            p += Math.log(1.0 - Math.exp(minusBeta * seg.getWidth()));
        }
        return p;
    }

    @Override
    public Object getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ArrayList<ChangePointParameter> getLeafChangePoints() {
        return this.cpList;
    }

    public ChangePointSegment[] getSegments() {
        return this.segments;
    }
}

