/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets;

import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.DAG.onsets.LineageChangePointModel;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.db.MySql;

public class EmbryoChangePoints
implements Runnable {
    int burnIn = 0;
    int iter = 100000;
    int thin = 0;
    SeriesEmbryo embryo;
    Map<String, ReversibleJump> algorithmMap;

    public EmbryoChangePoints(SeriesEmbryo embryo) throws Exception {
        this.embryo = embryo;
        this.algorithmMap = new TreeMap<String, ReversibleJump>();
    }

    public void runAllRoots() throws Exception {
        EmbryoCell[] roots;
        for (EmbryoCell root : roots = this.embryo.getRoots()) {
            this.runLineage(root.getName());
        }
    }

    public void runLineage(String lineage) throws Exception {
        EmbryoCell root = this.embryo.getCell(lineage);
        LineageChangePointModel model = new LineageChangePointModel(this.embryo, root);
        model.logProb();
        ReversibleJump algorithm = new ReversibleJump(model);
        algorithm.setBurnIn(this.burnIn);
        algorithm.setIterations(this.iter);
        algorithm.setThining(this.thin);
        this.algorithmMap.put(lineage, algorithm);
    }

    @Override
    public void run() {
        for (ReversibleJump algorithm : this.algorithmMap.values()) {
            Thread thread = new Thread(algorithm);
            thread.start();
        }
    }

    public ReversibleJump getAlgorithm(String lineage) {
        return this.algorithmMap.get(lineage);
    }

    public static void main(String[] args) throws Exception {
        SeriesEmbryo emb = new SeriesEmbryo(MySql.getMySql(), args[0], "zblot");
        EmbryoChangePoints embryoChangePoints = new EmbryoChangePoints(emb);
        embryoChangePoints.runAllRoots();
        embryoChangePoints.run();
    }
}

