/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.onsets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.onsets.ChangePointSegment;
import org.rhwlab.DAG.onsets.ResultStats;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.db.MySql;
import org.rhwlab.expression.ExpressionTimeSeries;

public class EmbryoChangePointResults {
    String series;

    public EmbryoChangePointResults(String seriesDir) throws Exception {
        File[] files;
        File dir = new File(seriesDir);
        this.series = dir.getName();
        String sql = String.format("delete from ImageExpressionChangePoint where Series='%s'", this.series);
        MySql.getMySql().execute(sql);
        for (File file : files = dir.listFiles()) {
            Map<String, ResultStats> results = this.getChangePointResults(file);
            this.saveResultsToDb(results);
        }
    }

    public static Map<String, ResultStats> ChangePointsToOnsets(double minExp, EmbryoCell cell, Map<String, ResultStats> cpMap) {
        EmbryoCell great;
        if (cell.getName().equals("MSaap")) {
            boolean bl = false;
        }
        TreeMap<String, ResultStats> ret = new TreeMap<String, ResultStats>();
        ResultStats stats = cpMap.get(cell.getName());
        if (stats != null) {
            EmbryoCell[] leaves;
            for (EmbryoCell leaf : leaves = cell.getLeaves()) {
                if (leaf.getName().equals("MSaapaaa")) {
                    boolean bl = false;
                }
                ExpressionTimeSeries ts = ExpressionTimeSeries.factory((EmbryoCell)leaf);
                double[] dirichlet = ChangePointSegment.dirichletForLeaf(leaf, cpMap);
                ChangePointSegment[] segments = ChangePointSegment.factory(ts.getLogAll(minExp), dirichlet);
                if (segments.length <= 1) continue;
                double ys = segments[1].getYStart();
                double ye = segments[1].getYEnd();
                if (!(segments[1].getYStart() >= segments[1].getYEnd())) continue;
                return ret;
            }
            ret.put(cell.getName(), stats);
            return ret;
        }
        EmbryoCell less = (EmbryoCell)cell.getLessDaughter();
        if (less != null) {
            ret.putAll(EmbryoChangePointResults.ChangePointsToOnsets(minExp, less, cpMap));
        }
        if ((great = (EmbryoCell)cell.getGreaterDaughter()) != null) {
            ret.putAll(EmbryoChangePointResults.ChangePointsToOnsets(minExp, great, cpMap));
        }
        return ret;
    }

    public final void saveResultsToDb(Map<String, ResultStats> results) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Insert into ImageExpressionChangePoint (Series,Cell,Probability,Mean) values(?,?,?,?)");
        for (String cell : results.keySet()) {
            ResultStats stats = results.get(cell);
            state.setString(1, this.series);
            state.setString(2, cell);
            state.setDouble(3, stats.p);
            state.setDouble(4, stats.mu);
            state.execute();
        }
    }

    public static Map<String, ResultStats> getChangePointsFromDB(String series, double threshold) throws Exception {
        TreeMap<String, ResultStats> ret = new TreeMap<String, ResultStats>();
        String sql = String.format("Select * from ImageExpressionChangePoint where Series='%s' and Probability > %f", series, threshold);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            ResultStats st = new ResultStats();
            st.mu = rs.getDouble("Mean");
            st.p = rs.getDouble("Probability");
            String cell = rs.getString("Cell");
            ret.put(cell, st);
        }
        return ret;
    }

    public final Map<String, ResultStats> getChangePointResults(File file) throws Exception {
        TreeMap<String, ResultStats> ret = new TreeMap<String, ResultStats>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        String[] headers = line.split(",");
        for (int i = 1; i < headers.length; ++i) {
            ret.put(headers[i], new ResultStats());
        }
        line = reader.readLine();
        int count = 0;
        while (line != null) {
            String[] tokens = line.split(",");
            ++count;
            for (int i = 1; i < tokens.length; ++i) {
                if (tokens[i].equals("NA")) continue;
                ResultStats result = ret.get(headers[i]);
                ++result.n;
                result.sum += Double.valueOf(tokens[i]).doubleValue();
                result.mu = result.sum / (double)result.n;
                result.p = (double)result.n / (double)count;
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String directory = "/net/waterston/vol2/home/gevirl/";
        EmbryoChangePointResults result = new EmbryoChangePointResults(directory + args[0]);
    }
}

