/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.multiembryo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.onsets.ResultStats;
import org.rhwlab.beans.SeriesMetaData;
import org.rhwlab.db.MySql;

public class MultiEmbryoResults {
    String gene;
    String construct;

    public MultiEmbryoResults(String directory) throws Exception {
        File[] files;
        File dir = new File(directory);
        String[] tokens = dir.getName().split("_");
        this.gene = tokens[0];
        this.construct = tokens[1];
        String sql = String.format("delete from ExpressionChangePoint where Gene='%s' and Construct='%s'", this.gene, this.construct);
        MySql.getMySql().execute(sql);
        for (File file : files = dir.listFiles()) {
            Map<String, ResultStats> results = this.getChangePointResults(file);
            this.saveResultsToDb(results);
        }
    }

    public static Map<String, ResultStats> getChangePointsFromDB(String series, double threshold) throws Exception {
        SeriesMetaData md = new SeriesMetaData(series);
        String construct = "Protein";
        if (md.getConstructType().equals("Plasmid")) {
            construct = "Promoter";
        }
        String gene = md.getGene();
        TreeMap<String, ResultStats> ret = new TreeMap<String, ResultStats>();
        String sql = String.format("Select * from ExpressionChangePoint where Gene='%s' and Construct='%s' and Probability > %f", gene, construct, threshold);
        ResultSet rs = MySql.getMySql().execute(sql);
        while (rs.next()) {
            String cell;
            ResultStats st = new ResultStats();
            st.mu = rs.getDouble("CPTime");
            st.p = rs.getDouble("Probability");
            st.cell = cell = rs.getString("Cell");
            ret.put(cell, st);
        }
        return ret;
    }

    public final Map<String, ResultStats> getChangePointResults(File file) throws Exception {
        TreeMap<String, ResultStats> ret = new TreeMap<String, ResultStats>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        String[] headers = line.split(",");
        for (int i = 1; i < headers.length; ++i) {
            ret.put(headers[i], new ResultStats());
        }
        line = reader.readLine();
        int count = 0;
        while (line != null) {
            String[] tokens = line.split(",");
            ++count;
            for (int i = 1; i < tokens.length; ++i) {
                if (tokens[i].equals("NA")) continue;
                ResultStats result = ret.get(headers[i]);
                ++result.n;
                result.sum += Double.valueOf(tokens[i]).doubleValue();
                result.mu = result.sum / (double)result.n;
                result.p = (double)result.n / (double)count;
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    public final void saveResultsToDb(Map<String, ResultStats> results) throws Exception {
        PreparedStatement state = MySql.getMySql().getStatement("Insert into ExpressionChangePoint (Gene,Construct,Cell,Probability,CPTime) values(?,?,?,?,?)");
        for (String cell : results.keySet()) {
            ResultStats stats = results.get(cell);
            state.setString(1, this.gene);
            state.setString(2, this.construct);
            state.setString(3, cell);
            state.setDouble(4, stats.p);
            state.setDouble(5, stats.mu);
            state.execute();
        }
    }

    public static void main(String[] args) throws Exception {
        String directory = "/net/waterston/vol2/home/gevirl/";
        MultiEmbryoResults result = new MultiEmbryoResults(directory + args[0]);
    }
}

