/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.multiembryo;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.DAG.Data;
import org.rhwlab.DAG.changepoints.Count;
import org.rhwlab.DAG.distributions.InverseGamma;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.models.ReversibleJumpModel;
import org.rhwlab.DAG.multiembryo.CellChangePoint;
import org.rhwlab.DAG.multiembryo.LeafDataLikelihood;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.expression.ExpressionTimeSeries;

public class MultiEmbryoModel
extends ReversibleJumpModel {
    String lineage;
    String choice;
    EmbryoCell targetLeaf;
    EmbryoCell lineageRoot;
    TreeSet<EmbryoCell> lineageCells;
    EmbryoCell[] leaves;
    SeriesEmbryo[] embryos;
    SulstonEmbryo sulston;
    double[] minExpressions;
    double[] ratios;
    Map<String, ExpressionTimeSeries>[] leafTimeSeriesMaps;
    static String[] jumps = new String[]{"Add", "Del", "Chg"};
    static Random rand = null;
    static double log3 = Math.log(3.0);
    NonNegative sigma;
    Map<String, CellChangePoint> changePointMap;
    boolean first = true;
    PrintStream stream;

    public MultiEmbryoModel() {
    }

    public MultiEmbryoModel(SulstonEmbryo sulston, SeriesEmbryo[] embryos, double[] ratios, String lineage) throws Exception {
        int i;
        this.lineage = lineage;
        this.embryos = embryos;
        this.ratios = ratios;
        this.sulston = sulston;
        this.stream = new PrintStream(lineage);
        if (rand == null) {
            rand = new Random();
        }
        this.lineageRoot = sulston.getEmbryo().getCell(lineage);
        this.lineageCells = this.lineageRoot.getAllCells();
        String sigmaName = "Sigma_" + this.lineageRoot.getName();
        this.stream.print(sigmaName);
        for (EmbryoCell cell : this.lineageCells) {
            this.stream.printf(",%s", cell.getName());
        }
        this.stream.println();
        EmbryoCell[] embryoCellLeaves = embryos[0].getCell(lineage).getLeaves();
        this.leaves = new EmbryoCell[embryoCellLeaves.length];
        for (i = 0; i < embryoCellLeaves.length; ++i) {
            this.leaves[i] = this.lineageRoot.getDescendent(embryoCellLeaves[i].getName());
        }
        this.leafTimeSeriesMaps = new HashMap[embryos.length];
        for (i = 0; i < embryos.length; ++i) {
            EmbryoCell[] embryoLeaves;
            this.leafTimeSeriesMaps[i] = new HashMap<String, ExpressionTimeSeries>();
            for (EmbryoCell leaf : embryoLeaves = embryos[i].getCell(lineage).getLeaves()) {
                this.leafTimeSeriesMaps[i].put(leaf.getName(), ExpressionTimeSeries.factory((EmbryoCell)leaf));
            }
        }
        this.changePointMap = new TreeMap<String, CellChangePoint>();
        this.sigma = new NonNegative(sigmaName, this, 0.2, 1.0);
        this.sigma.setPrior(new InverseGamma(1.0, 1.0));
        this.minExpressions = new double[embryos.length];
        for (i = 0; i < embryos.length; ++i) {
            this.minExpressions[i] = embryos[i].minExpression();
            this.constructLikelihoods(embryos[i], embryos[i].getCell(lineage), this.leafTimeSeriesMaps[i], this.minExpressions[i]);
        }
    }

    private MultiEmbryoModel shallowCopy() {
        MultiEmbryoModel copy = new MultiEmbryoModel();
        copy.embryos = this.embryos;
        copy.stream = this.stream;
        copy.lineageRoot = this.lineageRoot;
        copy.leaves = this.leaves;
        copy.leafTimeSeriesMaps = this.leafTimeSeriesMaps;
        copy.lineageCells = this.lineageCells;
        copy.sigma = this.sigma;
        copy.sigma = (NonNegative)this.sigma.copy(copy);
        copy.sigma.setPrior(new InverseGamma(1.0, 1.0));
        copy.minExpressions = this.minExpressions;
        copy.ratios = this.ratios;
        copy.sulston = this.sulston;
        copy.lineage = this.lineage;
        copy.changePointMap = new TreeMap<String, CellChangePoint>();
        copy.choice = this.choice;
        copy.targetLeaf = this.targetLeaf;
        return copy;
    }

    public static ArrayList<CellChangePoint> activeChangePoints(Map<String, CellChangePoint> changePointMap, EmbryoCell cell) {
        EmbryoCell parent = cell.getParentCell();
        ArrayList<CellChangePoint> ret = parent != null ? MultiEmbryoModel.activeChangePoints(changePointMap, parent) : new ArrayList();
        CellChangePoint cp = changePointMap.get(cell.getName());
        if (cp != null) {
            ret.add(cp);
        }
        return ret;
    }

    @Override
    public ReversibleJumpModel propose() {
        int i;
        this.targetLeaf = this.leaves[rand.nextInt(this.leaves.length)];
        ArrayList<CellChangePoint> leafChangePoints = MultiEmbryoModel.activeChangePoints(this.changePointMap, this.targetLeaf);
        this.choice = "Add";
        if (!leafChangePoints.isEmpty()) {
            this.choice = jumps[rand.nextInt(jumps.length)];
        }
        MultiEmbryoModel nextModel = this.shallowCopy();
        for (CellChangePoint cp : this.changePointMap.values()) {
            boolean found = false;
            for (i = 0; i < leafChangePoints.size(); ++i) {
                if (!leafChangePoints.get(i).getName().equals(cp.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            nextModel.addNode(cp);
            nextModel.changePointMap.put(cp.getName(), cp);
        }
        int n = leafChangePoints.size();
        if (this.choice.equals("Add")) {
            ++n;
        } else if (this.choice.equals("Del")) {
            --n;
        }
        ArrayList ancestors = this.targetLeaf.getAncestorsUpto(this.lineage);
        n = Math.min(n, ancestors.size());
        for (int count = 0; count < n; ++count) {
            int j = rand.nextInt(ancestors.size());
            EmbryoCell ancestor = (EmbryoCell)ancestors.get(j);
            CellChangePoint cp = new CellChangePoint(ancestor, nextModel);
            nextModel.changePointMap.put(cp.getName(), cp);
            ancestors.remove(j);
        }
        for (i = 0; i < this.embryos.length; ++i) {
            nextModel.constructLikelihoods(this.embryos[i], this.embryos[i].getCell(this.lineage), this.leafTimeSeriesMaps[i], this.minExpressions[i]);
        }
        Collection ps = nextModel.getParameters();
        return nextModel;
    }

    private void constructLikelihoods(SeriesEmbryo embryo, EmbryoCell embryoLineageCell, Map<String, ExpressionTimeSeries> leafTimeSeriesMap, double minExpression) {
        EmbryoCell[] embryoLeaves;
        for (EmbryoCell leaf : embryoLeaves = embryoLineageCell.getLeaves()) {
            String leafName = leaf.getName();
            double[] y = leafTimeSeriesMap.get(leafName).getLogAll(minExpression);
            LeafDataLikelihood like = new LeafDataLikelihood(embryoLineageCell, this.changePointMap, leaf, y, this.sigma);
            Data dataNode = new Data(leafName, this.changePointMap, (Model)this, like);
            dataNode.addParent(this.sigma);
            ArrayList<CellChangePoint> cps = MultiEmbryoModel.activeChangePoints(this.changePointMap, leaf);
            for (CellChangePoint cp : cps) {
                dataNode.addParent(cp);
            }
            Count count = new Count("Count", (Model)this, cps.size());
        }
    }

    @Override
    public double logProposal(ReversibleJumpModel next) {
        double p = 0.0;
        if (!MultiEmbryoModel.activeChangePoints(this.changePointMap, this.targetLeaf).isEmpty()) {
            p = -log3;
        }
        MultiEmbryoModel nextModel = (MultiEmbryoModel)next;
        ArrayList<CellChangePoint> cps = MultiEmbryoModel.activeChangePoints(nextModel.changePointMap, this.targetLeaf);
        int n = this.targetLeaf.getAncestorsInclusive().size();
        return p -= Math.log(n);
    }

    @Override
    public String getModelID() {
        StringBuilder builder = new StringBuilder();
        for (CellChangePoint cp : this.changePointMap.values()) {
            builder.append(":");
            builder.append(cp.getName());
        }
        return String.format("%s%d:%d", this.lineageRoot.getName(), this.changePointMap.size(), builder.toString().hashCode());
    }

    public EmbryoCell getLineage() {
        return this.lineageRoot;
    }

    @Override
    public void record() {
        this.stream.printf("%.4f", (Double)this.sigma.getValue());
        for (EmbryoCell cell : this.lineageCells) {
            CellChangePoint cp = this.changePointMap.get(cell.getName());
            if (cp != null) {
                this.stream.printf(",%.4f", (Double)cp.getValue());
                continue;
            }
            this.stream.print(",NA");
        }
        this.stream.println();
    }

    public EmbryoCell[] getLeaves() {
        return this.leaves;
    }

    public String getMove() {
        return String.format("%s %s", this.choice, this.targetLeaf.getName());
    }
}

