/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.multiembryo;

import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.DAG.models.ReversibleJump;
import org.rhwlab.DAG.multiembryo.MultiEmbryoModel;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.universalimaging.Embryo;

public class MultiEmbryoChangePoints
implements Runnable {
    int burnIn = 0;
    int iter = 100000;
    int thin = 0;
    String[] lineages = new String[]{"ABa", "ABp", "EMS", "P2"};
    Map<String, ReversibleJump> algorithmMap;

    public MultiEmbryoChangePoints(String[] seriesList) throws Exception {
        SulstonEmbryo sulston = new SulstonEmbryo(MySql.getMySql());
        SeriesEmbryo[] embryos = new SeriesEmbryo[seriesList.length];
        double[] sulstonRatios = new double[seriesList.length];
        for (int i = 0; i < seriesList.length; ++i) {
            embryos[i] = new SeriesEmbryo(MySql.getMySql(), seriesList[i], "zblot");
            sulston.sulstonize((Embryo)embryos[i]);
            sulstonRatios[i] = sulston.sulstonRatio((Embryo)embryos[i]);
        }
        this.algorithmMap = new TreeMap<String, ReversibleJump>();
        for (String lineage : this.lineages) {
            MultiEmbryoModel model = new MultiEmbryoModel(sulston, embryos, sulstonRatios, lineage);
            model.logProb();
            ReversibleJump algorithm = new ReversibleJump(model);
            algorithm.setBurnIn(this.burnIn);
            algorithm.setIterations(this.iter);
            algorithm.setThining(this.thin);
            this.algorithmMap.put(lineage, algorithm);
        }
    }

    @Override
    public void run() {
        for (ReversibleJump algorithm : this.algorithmMap.values()) {
            Thread thread = new Thread(algorithm);
            thread.start();
        }
    }

    public ReversibleJump getAlgorithm(String lineage) {
        return this.algorithmMap.get(lineage);
    }

    public static void main(String[] args) throws Exception {
        MultiEmbryoChangePoints embryoChangePoints = new MultiEmbryoChangePoints(args);
        embryoChangePoints.run();
    }
}

