/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.multiembryo;

import java.util.ArrayList;
import java.util.Map;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.multiembryo.CellChangePoint;
import org.rhwlab.DAG.multiembryo.MultiEmbryoModel;
import org.rhwlab.DAG.onsets.ChangePointSegment;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.beans.EmbryoCell;

public class LeafDataLikelihood
implements Distribution {
    EmbryoCell lineageRoot;
    ChangePointSegment[] segments;
    NonNegative variance;
    Map<String, CellChangePoint> cpMap;
    double[] y;
    ArrayList<CellChangePoint> cpList;
    static double minusBeta = Math.log(0.5) / 0.05;

    public LeafDataLikelihood(EmbryoCell embLineageRoot, Map<String, CellChangePoint> o, EmbryoCell leaf, double[] y, NonNegative variance) {
        this.lineageRoot = embLineageRoot;
        this.cpMap = o;
        this.variance = variance;
        this.y = y;
        this.cpList = MultiEmbryoModel.activeChangePoints(this.cpMap, leaf);
    }

    public static double[] dirichletFromCPs(ArrayList<CellChangePoint> cpList, double[] y, EmbryoCell lineageRoot) throws Exception {
        if (cpList.isEmpty()) {
            double[] dir = new double[]{1.0};
            return dir;
        }
        double w = y.length;
        ArrayList<Double> ret = new ArrayList<Double>();
        double start = 0.0;
        for (int i = 0; i < cpList.size(); ++i) {
            double embryoTime;
            CellChangePoint cellCP = cpList.get(i);
            double cpVal = (Double)cellCP.getValue();
            EmbryoCell embCell = lineageRoot.getDescendent(cellCP.getName());
            if (embCell == null) {
                boolean bl = false;
            }
            if (!((embryoTime = embCell.embryoTime(cpVal)) >= 0.0) || !(embryoTime < w)) continue;
            ret.add(new Double(embryoTime - start) / w);
            start = embryoTime;
        }
        ret.add(new Double(w - start) / w);
        double[] dir = new double[ret.size()];
        for (int i = 0; i < dir.length; ++i) {
            dir[i] = (Double)ret.get(i);
        }
        return dir;
    }

    @Override
    public Object sample() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double[] dirichlet = LeafDataLikelihood.dirichletFromCPs(this.cpList, this.y, this.lineageRoot);
        this.segments = ChangePointSegment.factory(this.y, dirichlet);
        double p = 0.0;
        double sig = (Double)this.variance.getValue();
        for (ChangePointSegment seg : this.segments) {
            for (int i = seg.getStart(); i <= seg.getEnd(); ++i) {
                p += Normal.logDensity(this.y[i], seg.getValue(i), sig);
            }
            p += Math.log(1.0 - Math.exp(minusBeta * seg.getWidth()));
        }
        return p;
    }

    @Override
    public Object getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ChangePointSegment[] getSegments() {
        return this.segments;
    }
}

