/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.models;

import java.io.PrintStream;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.rhwlab.DAG.models.ComponentWise;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.models.ReversibleJumpModel;

public class ReversibleJump
extends ComponentWise {
    int thin;
    Random rand;
    ReversibleJumpModel nextModel;
    TreeMap<String, PrintStream> streamMap = new TreeMap();

    public ReversibleJump(ReversibleJumpModel model) {
        this.model = model;
        this.rand = new Random();
    }

    @Override
    public void run() {
        try {
            this.skip = 0;
            this.params = this.model.getParameters();
            this.iter = 0;
            while (this.iter < this.iterations) {
                try {
                    this.step();
                    if (this.iter > this.burnIn) {
                        this.thin = 0;
                        String modelID = ((ReversibleJumpModel)this.model).getModelID();
                        PrintStream stream = this.streamMap.get(modelID);
                        if (stream == null) {
                            stream = new PrintStream(modelID);
                            this.streamMap.put(modelID, stream);
                            this.model.setFirstRecord(true);
                        } else {
                            this.model.setFirstRecord(false);
                        }
                        this.model.setRecordStream(stream);
                        this.model.record();
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                ++this.iter;
            }
            this.model.finish();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void step() throws Exception {
        ++this.thin;
        this.model.findAllParameters();
        super.step();
        double currentP = this.model.logProb();
        this.nextModel = ((ReversibleJumpModel)this.model).propose();
        double nextP = this.nextModel.logProb();
        double qForward = ((ReversibleJumpModel)this.model).logProposal(this.nextModel);
        double qReverse = this.nextModel.logProposal((ReversibleJumpModel)this.model);
        double mu = Math.log(this.rand.nextDouble());
        if (nextP != Double.NEGATIVE_INFINITY && mu < nextP - currentP - (qForward - qReverse)) {
            this.model = this.nextModel;
            int np = this.model.getParameters().size();
            currentP = nextP;
        }
    }

    public Model getProposedModel() {
        return this.nextModel;
    }

    public Set<String> getModelIDs() {
        return this.streamMap.keySet();
    }
}

