/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.models;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.Parameter;

public abstract class Model {
    PrintStream stream = System.out;
    boolean firstRecord = true;
    ArrayList<Node> nodes;
    HashMap<String, Parameter> params = null;
    Collection<Node> reportNodes = new ArrayList<Node>();

    public Model() {
        this.nodes = new ArrayList();
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public double logProb() throws Exception {
        double p = 0.0;
        for (Node node : this.nodes) {
            double nodeP = node.logConditionalProb();
            p += nodeP;
        }
        return p;
    }

    public Collection getParameters() {
        if (this.params == null) {
            this.findAllParameters();
        }
        return this.params.values();
    }

    public void findAllParameters() {
        this.params = new HashMap();
        for (Node node : this.nodes) {
            if (!(node instanceof Parameter)) continue;
            Parameter par = (Parameter)node;
            this.params.put(par.getName(), par);
        }
    }

    public void setOutFile(String fileName) throws Exception {
        this.setRecordStream(new PrintStream(fileName));
    }

    public void setRecordStream(PrintStream s) {
        this.stream = s;
    }

    public void setReportParams(List<String> paramNames) {
        this.getParameters();
        if (paramNames != null) {
            for (String paramName : paramNames) {
                this.reportNodes.add(this.params.get(paramName));
            }
        } else {
            this.reportNodes.addAll(this.params.values());
        }
    }

    public void addReportNode(Node node) {
        this.reportNodes.add(node);
    }

    public void record() {
        boolean firstParam;
        if (this.reportNodes.isEmpty()) {
            this.setReportParams(null);
        }
        if (this.firstRecord) {
            firstParam = true;
            for (Node param : this.reportNodes) {
                if (!firstParam) {
                    this.stream.print(",");
                }
                this.stream.print(param.getName());
                firstParam = false;
            }
            this.stream.println();
            this.firstRecord = false;
        }
        firstParam = true;
        for (Node param : this.reportNodes) {
            param.reportValue(this.stream, firstParam);
            firstParam = false;
        }
        this.stream.println();
    }

    public void finish() {
        this.stream.close();
        for (Parameter param : this.params.values()) {
            System.out.printf("%s: accepted %d\n", param.getName(), param.getAccepted());
        }
    }

    public void setFirstRecord(boolean first) {
        this.firstRecord = first;
    }

    public void setStream(PrintStream st) {
        this.stream = st;
    }

    public void init() throws Exception {
    }
}

