/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.models;

import java.util.Collection;
import java.util.Random;
import org.rhwlab.DAG.Parameter;
import org.rhwlab.DAG.models.Algorithm;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.pipeline.Pipeline;
import org.rhwlab.DAG.proposal.ProposalDistribution;

public class ComponentWise
extends Algorithm
implements Runnable {
    int skip;
    int iter;
    Model model;
    Collection<Parameter> params;
    Random rand = new Random();
    int recorded;
    int accepted;

    public ComponentWise() {
    }

    public ComponentWise(Model model) {
        this();
        this.setModel(model);
    }

    @Override
    public void run() {
        try {
            this.skip = 0;
            this.params = this.model.getParameters();
            this.iter = 0;
            while (this.iter < this.iterations) {
                try {
                    this.step();
                    if (this.iter >= this.burnIn && this.skip >= this.thining) {
                        this.model.record();
                        this.skip = 0;
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
                ++this.iter;
            }
            this.model.finish();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void step() throws Exception {
        if (this.params == null) {
            this.params = this.model.getParameters();
        }
        for (Parameter param : this.params) {
            if (Pipeline.tracing) {
                System.out.printf("ComponentWise.run: parameter=%s\n", param.getName());
            }
            try {
                Object currentParamValue = param.getValue();
                double currentP = param.logBlanketPosteriorProb();
                Object nextParamValue = param.propose();
                param.setValue(nextParamValue);
                double nextP = param.logBlanketPosteriorProb();
                if (Pipeline.tracing) {
                    System.out.printf("ComponentWise: currentP=%f\n", currentP);
                    System.out.printf("ComponentWise: nextP=%f\n", nextP);
                }
                ProposalDistribution proposalDist = param.getProposal();
                double forward = proposalDist.logDensity(currentParamValue, nextParamValue);
                double reverse = proposalDist.logDensity(nextParamValue, currentParamValue);
                double qDiff = forward - reverse;
                double mu = Math.log(this.rand.nextDouble());
                if (nextP != Double.NEGATIVE_INFINITY && mu < nextP - currentP - qDiff) {
                    if (this.iter >= this.burnIn) {
                        param.accepted();
                    }
                    if (!Pipeline.tracing) continue;
                    System.out.printf("ComponentWise: accept mu=%f\n", mu);
                    continue;
                }
                if (Pipeline.tracing) {
                    System.out.printf("ComponentWise: reject mu = %f\n", mu);
                }
                param.setValue(currentParamValue);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                System.out.println(param.getName());
                param.reportValue(System.out, true);
                System.exit(0);
            }
        }
        ++this.skip;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public final void setModel(Object m) {
        this.model = (Model)m;
    }
}

