/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.functions;

import java.util.ArrayList;
import org.rhwlab.DAG.Function;
import org.rhwlab.DAG.Node;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class SampledNormal
extends Function {
    Node mean;
    Node variance;
    double sampleStart;
    double sampleEnd;
    double sampleInc;

    @Override
    public void update() {
        double sum = 0.0;
        ArrayList<Double> list = new ArrayList<Double>();
        double mu = (Double)this.mean.getValue();
        double sig = Math.sqrt((Double)this.variance.getValue());
        for (double x = this.sampleStart; x <= this.sampleEnd; x += this.sampleInc) {
            double p = NormalDist.density((double)mu, (double)sig, (double)x);
            sum += p;
            list.add(p);
        }
        double[] v = new double[list.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (Double)list.get(i) / sum;
        }
        this.setValue(v);
    }

    public void setMean(Object obj) {
        this.mean = (Node)obj;
        this.addParent(this.mean);
    }

    public void setVariance(Object obj) {
        this.variance = (Node)obj;
        this.addParent(this.variance);
    }

    public void setSampleStart(Object obj) {
        this.sampleStart = (Double)obj;
    }

    public void setSampleEnd(Object obj) {
        this.sampleEnd = (Double)obj;
    }

    public void setSampleInc(Object obj) {
        this.sampleInc = (Double)obj;
    }

    @Override
    public String getName() {
        String base = super.getName();
        if (base != null) {
            double[] v = (double[])this.getValue();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(base);
                builder.append(String.format("_%d", i));
            }
            return builder.toString();
        }
        return this.getParents().get(0).getName();
    }
}

