/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.functions;

import org.rhwlab.DAG.Function;
import org.rhwlab.DAG.Node;

public class FixedPositiveSum
extends Function {
    double target;

    @Override
    public void update() {
        Node parent = this.getParents().get(0);
        double[] parentValues = parent.getValue() instanceof Double ? new double[]{(Double)parent.getValue()} : (double[])parent.getValue();
        double sum = 0.0;
        for (int i = 0; i < parentValues.length; ++i) {
            sum += Math.abs(parentValues[i]);
        }
        double[] v = new double[parentValues.length];
        for (int i = 0; i < parentValues.length; ++i) {
            v[i] = this.target * Math.abs(parentValues[i]) / sum;
        }
        this.setValue(v);
        if (this.getName() == null) {
            super.setName(parent.getName());
        }
    }

    public void setTarget(Double s) {
        this.target = s;
    }

    @Override
    public String getName() {
        String base = super.getName();
        if (base != null) {
            double[] v = (double[])this.getValue();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(base);
                builder.append(String.format("[%d]", i));
            }
            return builder.toString();
        }
        return this.getParents().get(0).getName();
    }
}

