/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.util.Random;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;

public class UniformDist
implements Distribution {
    static Random rand = null;
    Node min;
    Node max;

    public UniformDist() {
    }

    public UniformDist(double minValue, double maxValue) {
        this(new Constant("Minimum", minValue), new Constant("Maximum", maxValue));
    }

    public UniformDist(Constant min, Node max) {
        this.max = max;
        this.min = min;
        this.init();
    }

    public void init() {
        if (rand == null) {
            rand = new Random();
        }
    }

    @Override
    public Object sample() {
        double r = rand.nextDouble();
        double x = (Double)this.min.getValue() + r * ((Double)this.max.getValue() - (Double)this.min.getValue());
        return new Double(x);
    }

    @Override
    public double logDensity(Object o) throws Exception {
        if (o instanceof Double) {
            Double x = (Double)o;
            if (x < (Double)this.min.getValue() || x > (Double)this.max.getValue()) {
                return Double.NEGATIVE_INFINITY;
            }
            return 0.0;
        }
        if (o instanceof double[]) {
            for (double x : (double[])o) {
                if (!(x < (Double)this.min.getValue()) && !(x > (Double)this.max.getValue())) continue;
                return Double.NEGATIVE_INFINITY;
            }
            return 0.0;
        }
        throw new Exception("unknown data type in UniformDist.logDensity");
    }

    @Override
    public Object getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getMean() {
        return 0.5 * ((Double)this.max.getValue() - (Double)this.min.getValue());
    }

    public void setMin(double m) {
        this.min = new Constant("Minimum", m);
    }

    public void setMax(double m) {
        this.max = new Constant("Maximum", m);
    }

    public void setMin(Object obj) {
        if (obj instanceof Node) {
            this.min = (Node)obj;
        } else if (obj instanceof Double) {
            this.min = new Constant("Min", (Double)obj);
        } else {
            System.out.println("Error in UniformDist.setMin()");
        }
    }

    public void setMax(Object obj) {
        if (obj instanceof Node) {
            this.max = (Node)obj;
        } else if (obj instanceof Double) {
            this.max = new Constant("Max", (Double)obj);
        } else {
            System.out.println("Error in UniformDist.setMax()");
        }
    }
}

