/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.util.Random;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.pipeline.Pipeline;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class Normal
implements Distribution {
    static double sqrt2;
    static double a;
    static double log2pi;
    static Random rnd;
    Node mean;
    Node variance;

    public Normal() {
    }

    public Normal(double m, double v) {
        this(new Constant("Mean", m), new Constant("Variance", v));
    }

    public Normal(Node mean, Node variance) {
        this.mean = mean;
        this.variance = variance;
        if (rnd == null) {
            rnd = new Random();
            log2pi = Math.log(Math.PI * 2);
            sqrt2 = Math.sqrt(2.0);
            a = 0.1400122886866665;
        }
    }

    @Override
    public Object sample() {
        double mu = (Double)this.mean.getValue();
        double var = (Double)this.variance.getValue();
        return mu + Math.sqrt(var) * rnd.nextGaussian();
    }

    @Override
    public double logDensity(Object obj) {
        double x = (Double)obj;
        double mu = (Double)this.mean.getValue();
        double var = (Double)this.variance.getValue();
        if (Pipeline.tracing) {
            System.out.printf("Normal.logDensity: x=%f,mu=%f,var=%f\n", x, mu, var);
        }
        return Normal.logDensity(x, mu, var);
    }

    public static double logDensity(double x, double mu, double var) {
        double d = x - mu;
        double p = -0.5 * (d * d / var + Math.log(var) + log2pi);
        if (p == Double.NEGATIVE_INFINITY) {
            boolean bl = false;
        }
        return p;
    }

    @Override
    public Double getVariance() {
        return (Double)this.variance.getValue();
    }

    @Override
    public Double getMean() {
        return (Double)this.mean.getValue();
    }

    public double CDF(double x) {
        double mu = (Double)this.mean.getValue();
        double var = (Double)this.variance.getValue();
        double sig = Math.sqrt(var);
        return NormalDist.cdf((double)mu, (double)sig, (double)x);
    }

    protected static double errorFunction(double value) {
        double valSq = value * value;
        double newVal = value / Math.abs(value) * Math.sqrt(1.0 - Math.exp(-valSq * (1.2732395447351628 + a * valSq) / (1.0 + a * valSq)));
        if (newVal >= 1.0) {
            return 0.9999999999;
        }
        if (newVal <= -1.0) {
            return -0.9999999999;
        }
        return newVal;
    }

    public void setMean(Object m) {
        if (m instanceof Double) {
            this.mean = new Constant("Mean", m);
        } else if (m instanceof Node) {
            this.mean = (Node)m;
        }
    }

    public void setVariance(Object v) {
        if (v instanceof Double) {
            this.variance = new Constant("Variance", v);
        } else if (v instanceof Node) {
            this.variance = (Node)v;
        }
    }
}

