/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.pipeline.Pipeline;

public class NonNegativeNormal
extends Normal {
    public NonNegativeNormal(Node mean, Node variance) {
        super(mean, variance);
    }

    @Override
    public Object sample() {
        Object samp = super.sample();
        while ((Double)samp < 0.0) {
            samp = super.sample();
        }
        return samp;
    }

    @Override
    public double logDensity(Object o) {
        double x = (Double)o;
        if (x >= 0.0) {
            double p = super.logDensity(o);
            double cdf = super.CDF(0.0);
            p -= Math.log(1.0 - cdf);
            if (Pipeline.tracing) {
                System.out.printf("NonNegativeNormal.logDensity: cdf=%f , p=%f\n", cdf, p);
            }
            if (p == Double.NEGATIVE_INFINITY || p == Double.NaN) {
                System.err.println("Error in NonNegativeNormal.logDensity");
                System.exit(0);
            }
            return p;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static void main(String[] args) {
        double mu = 0.0;
        double sigma = 1.0;
        NonNegativeNormal dist = new NonNegativeNormal(new Constant("Mu", mu), new Constant("Sigma", sigma));
        double step = 1.0E-5;
        double end = 5.0;
        double sum = 0.0;
        double x = 0.0;
        while (x <= end) {
            sum += Math.exp(dist.logDensity(x));
            x = step + x;
        }
        System.out.print(sum * step);
    }
}

