/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;
import org.rhwlab.DAG.distributions.Distribution;
import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.randvar.LognormalGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;

public class LogNormal
implements Distribution {
    static RandomStream stream = new MRG32k3a();
    double mu;
    double sigma;

    public LogNormal() {
        if (stream == null) {
            stream = new MRG32k3a();
        }
    }

    public LogNormal(double mu, double sigma) {
        this();
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public Object sample() {
        return LognormalGen.nextDouble((RandomStream)stream, (double)this.mu, (double)this.sigma);
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double p = Math.log(LognormalDist.density((double)this.mu, (double)this.sigma, (double)((Double)o)));
        return p;
    }

    @Override
    public Object getVariance() {
        return this.sigma * this.sigma;
    }

    @Override
    public Object getMean() {
        return this.mu;
    }

    public static void main(String[] args) throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                double mu = 0.0;
                double sigma = 0.25;
                LogNormal dist = new LogNormal(mu, sigma);
                String title = String.format("Mu=%f,Sig=%f", mu, sigma);
                int n = 10000;
                double[] samples = new double[n];
                double[] logSamples = new double[n];
                double[] expSamples = new double[n];
                for (int i = 0; i < n; ++i) {
                    samples[i] = (Double)dist.sample();
                    logSamples[i] = Math.log(samples[i]);
                    expSamples[i] = Math.exp(samples[i]);
                }
                HistogramDataset histDataSet = new HistogramDataset();
                histDataSet.addSeries((Comparable)((Object)"samples"), samples, 1000);
                histDataSet.addSeries((Comparable)((Object)"log(samples)"), logSamples, 1000);
                JFreeChart chart = ChartFactory.createHistogram((String)title, (String)"X", null, (IntervalXYDataset)histDataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
                panel.add((Component)new ChartPanel(chart));
                XYSeries series = new XYSeries((Comparable)((Object)"LogNormalDist"));
                double delta = 0.003;
                int i = 1;
                while ((double)i <= 1000.0) {
                    double x = (double)i * delta;
                    try {
                        double y = Math.exp(dist.logDensity(new Double(x)));
                        series.add(x, y);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    ++i;
                }
                JFrame dialog = new JFrame();
                dialog.setDefaultCloseOperation(3);
                dialog.setContentPane(panel);
                dialog.setSize(500, 500);
                dialog.setVisible(true);
            }
        });
    }
}

