/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.awt.Container;
import javax.swing.JDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import umontreal.iro.lecuyer.probdist.InverseGammaDist;

public class InverseGamma
implements Distribution {
    Node alpha;
    Node beta;

    public InverseGamma() {
    }

    public void setAlpha(double a) {
        this.alpha = new Constant("Alpha", new Double(a));
    }

    public void setBeta(double b) {
        this.beta = new Constant("Beta", new Double(b));
    }

    public InverseGamma(double a, double b) {
        this(new Constant("Alpha", new Double(a)), new Constant("Beta", new Double(b)));
    }

    public InverseGamma(Node alpha, Node beta) {
        this.beta = beta;
        this.alpha = alpha;
    }

    @Override
    public Object sample() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) {
        double x = (Double)o;
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double p = InverseGammaDist.density((double)((Double)this.alpha.getValue()), (double)((Double)this.beta.getValue()), (double)x);
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double logp = Math.log(p);
        if (logp == Double.NEGATIVE_INFINITY || logp == Double.NaN) {
            System.err.println("Error in InverseGamma.logDensity");
            System.exit(0);
        }
        return logp;
    }

    @Override
    public Double getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Double getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        double alpha = Double.valueOf(args[0]);
        double beta = Double.valueOf(args[1]);
        double start = Double.valueOf(args[2]);
        double end = Double.valueOf(args[3]);
        int n = 200;
        double delta = (end - start) / (double)n;
        InverseGamma igamma = new InverseGamma(alpha, beta);
        XYSeries series = new XYSeries((Comparable)((Object)"InverseGammaDist"));
        for (double x = start; x <= end; x += delta) {
            double p = igamma.logDensity(new Double(x));
            double y = 0.0;
            if (p != Double.NEGATIVE_INFINITY) {
                y = Math.exp(p);
            }
            series.add(x, y);
        }
        XYSeriesCollection collect = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)String.format("alpha=%s,beta=%s", alpha, beta), (String)"X", (String)"Density", (XYDataset)collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        ChartPanel panel = new ChartPanel(chart);
        JDialog dialog = new JDialog();
        dialog.setContentPane((Container)panel);
        dialog.setSize(500, 500);
        dialog.setVisible(true);
    }
}

