/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.util.Random;
import org.rhwlab.DAG.distributions.Distribution;
import org.rhwlab.DAG.distributions.HasMean;
import org.rhwlab.DAG.distributions.MultiVariate;
import org.rhwlab.DAG.distributions.Normal;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;

public class IIDMultiVariateNormal
implements Distribution,
MultiVariate,
HasMean {
    static RandomStream stream = null;
    static Random rnd = null;
    int N = 1;
    double initialMean = 0.0;
    double[] mu;
    double sigma;
    double var;

    public IIDMultiVariateNormal() {
        if (stream == null) {
            stream = new MRG32k3a();
            rnd = new Random();
        }
        this.initializeMean();
    }

    public IIDMultiVariateNormal(double sigma) {
        this();
        this.setSigma(sigma);
    }

    @Override
    public Object sample() {
        double[] ret = new double[this.mu.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = NormalGen.nextDouble((RandomStream)stream, (double)this.mu[i], (double)this.sigma);
        }
        return ret;
    }

    @Override
    public double logDensity(Object o) throws Exception {
        if (o instanceof Double) {
            return Normal.logDensity((Double)o, this.initialMean, this.var);
        }
        double[] xs = (double[])o;
        double ret = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            ret += Normal.logDensity(xs[i], this.mu[i], this.var);
        }
        return ret;
    }

    @Override
    public Object getVariance() {
        return this.sigma * this.sigma;
    }

    @Override
    public Object getMean() {
        return this.mu;
    }

    @Override
    public void setMean(Object obj) {
        this.mu = (double[])obj;
    }

    public void setN(Integer n) {
        this.N = n;
        this.initializeMean();
    }

    public void setInitialMean(Double m) {
        this.initialMean = m;
        this.initializeMean();
    }

    private void initializeMean() {
        this.mu = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.mu[i] = this.initialMean;
        }
    }

    public final void setSigma(Double sig) {
        this.sigma = sig;
        this.var = this.sigma * this.sigma;
    }

    @Override
    public int getN() {
        return this.N;
    }
}

