/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import java.awt.Container;
import javax.swing.JDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Distribution;
import umontreal.iro.lecuyer.probdist.GammaDist;

public class Gamma
implements Distribution {
    Node k;
    Node theta;

    public Gamma() {
    }

    public Gamma(double k, double theta) {
        this(new Constant("K", new Double(k)), new Constant("Theta", new Double(theta)));
    }

    public Gamma(Node k, Node theta) {
        this.k = k;
        this.theta = theta;
    }

    @Override
    public Object sample() {
        double alpha = (Double)this.k.getValue();
        double lambda = 1.0 / (Double)this.theta.getValue();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double x = (Double)o;
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double alpha = (Double)this.k.getValue();
        double lambda = 1.0 / (Double)this.theta.getValue();
        double logP = Math.log(GammaDist.density((double)alpha, (double)lambda, (double)x));
        return logP;
    }

    @Override
    public Double getVariance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Double getMean() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setK(Object obj) {
        this.k = new Constant("K", (Double)obj);
    }

    public void setTheta(Object obj) {
        this.theta = new Constant("Theta", (Double)obj);
    }

    public static void main(String[] args) throws Exception {
        double k = Double.valueOf(args[0]);
        double theta = Double.valueOf(args[1]);
        double start = Double.valueOf(args[2]);
        double end = Double.valueOf(args[3]);
        int n = 200;
        double delta = (end - start) / (double)n;
        Gamma gamma = new Gamma(k, theta);
        XYSeries series = new XYSeries((Comparable)((Object)"GammaDist"));
        for (double x = start; x <= end; x += delta) {
            double y = Math.exp(gamma.logDensity(new Double(x)));
            System.out.println(y);
            series.add(x, y);
        }
        XYSeriesCollection collect = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)String.format("k=%s,theta=%s", k, theta), (String)"X", (String)"Density", (XYDataset)collect, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        ChartPanel panel = new ChartPanel(chart);
        JDialog dialog = new JDialog();
        dialog.setContentPane((Container)panel);
        dialog.setSize(500, 500);
        dialog.setVisible(true);
    }
}

