/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.distributions;

import org.rhwlab.DAG.distributions.Distribution;
import umontreal.iro.lecuyer.probdistmulti.DirichletDist;
import umontreal.iro.lecuyer.randvarmulti.DirichletGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;

public class Dirichlet
implements Distribution {
    int n;
    DirichletDist dist;
    DirichletGen gen;
    double[] a;
    double alpha;

    public Dirichlet() {
    }

    public Dirichlet(double alpha) {
        this.alpha = alpha;
    }

    public Dirichlet(double alpha, int n) {
        this.a = new double[n];
        for (int i = 0; i < n; ++i) {
            this.a[i] = alpha;
        }
        this.gen = new DirichletGen((RandomStream)new MRG32k3a(), this.a);
        this.dist = new DirichletDist(this.a);
    }

    public Dirichlet(double[] a) {
        this.a = a;
        this.gen = new DirichletGen((RandomStream)new MRG32k3a(), a);
        this.dist = new DirichletDist(a);
    }

    public void init() {
        this.a = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.a[i] = this.alpha;
        }
        this.gen = new DirichletGen((RandomStream)new MRG32k3a(), this.a);
        this.dist = new DirichletDist(this.a);
    }

    @Override
    public Object sample() {
        double[] p = new double[this.a.length];
        this.gen.nextPoint(p);
        return p;
    }

    @Override
    public double logDensity(Object o) throws Exception {
        double[] x = (double[])o;
        if (x.length == 1) {
            return 0.0;
        }
        if (this.dist != null) {
            double p = DirichletDist.density((double[])this.a, (double[])x);
            double ret = Math.log(p);
            return ret;
        }
        double[] as = new double[x.length];
        for (int i = 0; i < as.length; ++i) {
            as[i] = this.alpha / (double)as.length;
        }
        return Math.log(DirichletDist.density((double[])as, (double[])x));
    }

    @Override
    public Object getVariance() {
        return this.dist.getCovariance();
    }

    @Override
    public Object getMean() {
        return this.dist.getMean();
    }

    public void setAlpha(Object obj) {
        this.alpha = (Double)obj;
    }

    public void setN(Object obj) {
        this.n = (Integer)obj;
    }

    public static void main(String[] args) {
        int i;
        double[] a = new double[args.length];
        double[] x = new double[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            x[i2] = Double.valueOf(args[i2]);
            a[i2] = 1.0E-10;
        }
        double sum = 0.0;
        for (i = 0; i < x.length; ++i) {
            sum += x[i];
        }
        for (i = 0; i < x.length; ++i) {
            x[i] = x[i] / sum;
        }
        double p = DirichletDist.density((double[])a, (double[])x);
        System.out.println(p);
    }
}

