/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.util.HashMap;
import java.util.Set;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Difference;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.parameters.NonNegative;
import org.rhwlab.DAG.parameters.RandomWalkParameter;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PCADataSource;

public class ZMatrix {
    Integer N;
    DataSource source;
    Model model;
    KdeFile file;
    HashMap<String, Node[]> zMap;

    public ZMatrix(int N, DataSource source, Model model, KdeFile file) throws Exception {
        this.N = N;
        this.source = source;
        this.model = model;
        this.file = file;
        this.init();
    }

    public void init() throws Exception {
        this.zMap = new HashMap();
        Set features = this.source.getFeatures();
        Normal prior = new Normal(new Constant("Zero", 0.0), new Constant("One", 1.0));
        for (String feature : features) {
            int i;
            boolean allConstant = true;
            Node[] z = new Node[this.N.intValue()];
            for (i = 0; i < this.N; ++i) {
                String featureName = String.format("%s_%d", feature, i);
                Double v = null;
                if (this.file != null) {
                    v = this.file.getValue(featureName, "Mode");
                }
                if (v == null) {
                    if (this.source instanceof PCADataSource) {
                        z[i] = new RandomWalkParameter(featureName, this.model, 30.0);
                    } else if (this.source instanceof DataSource) {
                        RandomWalkParameter p = new RandomWalkParameter(featureName, this.model, 1.0);
                        p.setPrior(prior);
                        z[i] = p;
                    } else {
                        z[i] = new NonNegative(featureName, this.model, 30.0);
                    }
                    allConstant = false;
                    continue;
                }
                z[i] = new Constant(featureName, v);
            }
            if (!allConstant) {
                for (i = 1; i < this.N; ++i) {
                    Difference zDiff = new Difference(feature + "_Difference", this.model, z[i], z[i - 1]);
                    zDiff.setPrior(new Normal(new Constant("Zero", 0.0), new Constant("Small", 0.1)));
                }
            }
            this.zMap.put(feature, z);
        }
    }

    public Node[] getZ(String feature) {
        return this.zMap.get(feature);
    }

    public void setN(Integer n) {
        this.N = n;
    }

    public void setSource(Object src) {
        this.source = (DataSource)src;
    }

    public void setKDE(Object kde) {
        this.file = (KdeFile)kde;
    }

    public void setModel(Object mod) {
        this.model = (Model)mod;
    }
}

