/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.util.HashMap;
import org.rhwlab.DAG.Constant;
import org.rhwlab.DAG.Data;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.decomp.Convolved;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.decomp.ZMatrix;
import org.rhwlab.DAG.distributions.Normal;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.parameters.LogNonNegative;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.PCADataSource;

public class XMatrix {
    public XMatrix(String experiment, DataSource source, ZMatrix Z, PMatrix P, HashMap<String, LogNonNegative> sigmaMap, Model model) throws Exception {
        double[] sampleTimes = source.getExperimentTimes(experiment);
        double varianceProposalSigma = 5.0;
        double initialVariance = 10.0;
        for (String feature : source.getFeatures()) {
            LogNonNegative sigma = sigmaMap.get(feature);
            double[] x = source instanceof PCADataSource ? source.getExpFeatureData(experiment, feature) : (source instanceof DataSource ? source.getZScoreData(experiment, feature) : source.getNormalizedFeatureData(experiment, feature));
            Node[] zNodes = Z.getZ(feature);
            for (int i = 0; i < x.length; ++i) {
                String nodeName = String.format("%s_%s_%d", feature, experiment, (int)sampleTimes[i]);
                Convolved mu = new Convolved(nodeName + "_mu", zNodes, P, i, model);
                Normal like = new Normal(mu, new Constant("SmallSigma", 0.1));
                Data xNode = new Data(nodeName + "_data", (Object)x[i], model, like);
                xNode.addParent(mu);
            }
        }
    }
}

