/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.ExperimentDataSource;
import org.rhwlab.RNASeq.PMatrixKdeFile;

public class UnifiedResult {
    int n;
    double timeInc;
    Double firstTime = null;
    TreeMap<String, double[]> map = new TreeMap();
    HashMap<String, List<Integer>> samplesMap = new HashMap();
    HashMap<String, List<Double>> timesMap = new HashMap();
    double[] unifiedTimes;
    String resultFile;

    public UnifiedResult() throws Exception {
        this("/net/waterston/vol2/home/gevirl/Unification/DAG/AllGenes.norm", null, "46.6491653", new Double(38.144));
    }

    public UnifiedResult(String resultFile) throws Exception {
        this.readResultFile(resultFile);
    }

    public UnifiedResult(String resultFile, String timesFile, String inc, Double firstTime) throws Exception {
        this(resultFile, timesFile, inc);
        this.firstTime = firstTime;
    }

    public UnifiedResult(String resultFile, String timesFile, String inc) throws Exception {
        this.timeInc = Double.valueOf(inc);
        this.readResultFile(resultFile);
        if (timesFile != null) {
            BufferedReader reader = new BufferedReader(new FileReader(timesFile));
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = line.split(",");
                List<Integer> samples = this.samplesMap.get(tokens[0]);
                List<Double> times = this.timesMap.get(tokens[0]);
                if (samples == null) {
                    samples = new ArrayList<Integer>();
                    times = new ArrayList<Double>();
                    this.samplesMap.put(tokens[0], samples);
                    this.timesMap.put(tokens[0], times);
                }
                samples.add(new Integer(tokens[1]));
                times.add(new Double(tokens[2]));
                line = reader.readLine();
            }
            reader.close();
        }
    }

    public void readResultFile(String resultFile) throws Exception {
        this.resultFile = resultFile;
        BufferedReader reader = new BufferedReader(new FileReader(resultFile));
        String line = reader.readLine();
        if (line.contains("(")) {
            this.readResultFileComplexFormat();
        } else {
            this.readResultFileSimpleFormat();
        }
        reader.close();
    }

    public void readResultFileComplexFormat() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(this.resultFile));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            double[] data = new double[tokens.length - 1];
            for (int i = 0; i < data.length; ++i) {
                String v = tokens[i + 1];
                int index = v.indexOf(40);
                data[i] = Double.valueOf(v.substring(0, index));
                if (!(data[i] < 0.0)) continue;
                data[i] = 0.0;
            }
            this.map.put(tokens[0], data);
            line = reader.readLine();
        }
        reader.close();
    }

    public void readResultFileSimpleFormat() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(this.resultFile));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            double[] data = new double[tokens.length - 1];
            for (int i = 0; i < data.length; ++i) {
                String v = tokens[i + 1];
                data[i] = Double.valueOf(v);
                if (!(data[i] < 0.0)) continue;
                data[i] = 0.0;
            }
            this.map.put(tokens[0], data);
            line = reader.readLine();
        }
        reader.close();
    }

    public Set<String> getGeneNames() {
        return this.map.keySet();
    }

    public double[] getStageData(int stage) {
        double[] ret = new double[this.map.size()];
        int i = 0;
        for (Map.Entry<String, double[]> entry : this.map.entrySet()) {
            double[] data = entry.getValue();
            ret[i] = data[stage];
            ++i;
        }
        return ret;
    }

    public double[] getStageData(String[] genes, int stage) {
        double[] ret = new double[genes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getGeneData(genes[i])[stage];
        }
        return ret;
    }

    public double[] getGeneData(String geneName) {
        if (geneName == null) {
            boolean bl = false;
        }
        return this.map.get(geneName);
    }

    public double[] getTimes(String exp) {
        List<Double> timesList = this.timesMap.get(exp);
        double[] ret = new double[timesList.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = timesList.get(i);
        }
        return ret;
    }

    public Set<String> getExperiments() {
        return this.samplesMap.keySet();
    }

    public int[] getSamples(String exp) {
        List<Integer> samplesList = this.samplesMap.get(exp);
        int[] ret = new int[samplesList.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = samplesList.get(i);
        }
        return ret;
    }

    public double[] getUnifiedTimes() {
        if (this.unifiedTimes != null) {
            return this.unifiedTimes;
        }
        double[] data = this.map.get(this.map.firstKey());
        double[] ret = new double[data.length];
        ret[0] = this.firstTime == null ? this.timeInc : this.firstTime;
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = ret[i - 1] + this.timeInc;
        }
        return ret;
    }

    public void setUnifiedTimes(double[] unifiedTimes) {
        this.unifiedTimes = unifiedTimes;
    }

    public int getStageCount() {
        return this.getUnifiedTimes().length;
    }

    public double getTimeInc() {
        return this.timeInc;
    }

    public Double unifiedValue(String gene, double time) {
        Double ret = null;
        double[] t = this.getUnifiedTimes();
        if (time > t[t.length - 1]) {
            return ret;
        }
        for (int i = 0; i < t.length - 1; ++i) {
            if (!(t[i] <= time) || !(time <= t[i + 1])) continue;
            double[] d = this.getGeneData(gene);
            ret = new Double(d[i] + (time - t[i]) * (d[i + 1] - d[i + 1]) / (t[i + 1] - t[i]));
        }
        return ret;
    }

    public double unifiedValue(String gene, double[] fractions) {
        double ret = 0.0;
        double[] d = this.getGeneData(gene);
        for (int i = 0; i < d.length; ++i) {
            ret += fractions[i] * d[i];
        }
        return ret;
    }

    public double rmsError(DataSource source, PMatrixKdeFile kde) throws Exception {
        String[] experiments;
        this.n = 0;
        double e = 0.0;
        for (String experiment : experiments = source.getExperiments()) {
            ExperimentDataSource expSource = source.getExperimentSource(experiment);
            double[] sampleTimes = expSource.getTimes();
            for (int i = 0; i < sampleTimes.length; ++i) {
                sampleTimes[i] = kde.warpTime(experiment, sampleTimes[i]);
            }
            for (String gene : this.getGeneNames()) {
                double[] dcpm = expSource.getFeatureData(gene);
                if (dcpm == null) {
                    boolean bl = false;
                }
                for (int i = 0; i < dcpm.length; ++i) {
                    ++this.n;
                    try {
                        double d = dcpm[i] - this.unifiedValue(gene, sampleTimes[i]);
                        e += d * d;
                        continue;
                    }
                    catch (Exception exc) {
                        boolean bl = false;
                    }
                }
            }
        }
        return Math.sqrt(e) / (double)this.n;
    }

    public double rmsErrorNoTimeWarping(DataSource source, PMatrixKdeFile kde) throws Exception {
        String[] experiments;
        this.n = 0;
        double e = 0.0;
        for (String experiment : experiments = source.getExperiments()) {
            ExperimentDataSource expSource = source.getExperimentSource(experiment);
            double[] sampleTimes = expSource.getTimes();
            PMatrix P = new PMatrix(17, sampleTimes, experiment, null, kde);
            for (String gene : this.getGeneNames()) {
                double[] dcpm = expSource.getFeatureData(gene);
                for (int i = 0; i < dcpm.length; ++i) {
                    ++this.n;
                    try {
                        double[] f = P.getColumn(i);
                        double d = dcpm[i] - this.unifiedValue(gene, f);
                        e += d * d;
                        continue;
                    }
                    catch (Exception exc) {
                        boolean bl = false;
                    }
                }
            }
        }
        return Math.sqrt(e) / (double)this.n;
    }

    public double rmsErrorNoTimeWarping(String gene, DataSource source, PMatrixKdeFile kde) throws Exception {
        String[] experiments;
        this.n = 0;
        double e = 0.0;
        for (String experiment : experiments = source.getExperiments()) {
            ExperimentDataSource expSource = source.getExperimentSource(experiment);
            double[] sampleTimes = expSource.getTimes();
            PMatrix P = new PMatrix(17, sampleTimes, experiment, null, kde);
            double[] dcpm = expSource.getFeatureData(gene);
            for (int i = 0; i < dcpm.length; ++i) {
                ++this.n;
                try {
                    double[] f = P.getColumn(i);
                    double d = dcpm[i] - this.unifiedValue(gene, f);
                    e += d * d;
                    continue;
                }
                catch (Exception exc) {
                    boolean bl = false;
                }
            }
        }
        return Math.sqrt(e) / (double)this.n;
    }

    public int getN() {
        return this.n;
    }

    public LinkedHashMap<String, double[]> pairwiseCorrelation(String[] genes) {
        int total = 0;
        SpearmansCorrelation spear = new SpearmansCorrelation();
        LinkedHashMap<String, double[]> ret = new LinkedHashMap<String, double[]>();
        for (int i = 1; i < genes.length; ++i) {
            String gene = genes[i];
            double[] geneData = this.map.get(gene);
            double[] corrs = new double[i];
            for (int j = 0; j < i; ++j) {
                String other = genes[j];
                double[] otherData = this.map.get(other);
                corrs[j] = geneData != null && otherData != null ? spear.correlation(geneData, otherData) : Double.NaN;
            }
            total += corrs.length;
            ret.put(gene, corrs);
        }
        Set keys = ret.keySet();
        return ret;
    }

    public List<String> filterGenesByThreshold(Set<String> genes, double threshold) {
        ArrayList<String> ret = new ArrayList<String>();
        block0: for (String gene : genes) {
            double[] data = this.map.get(gene);
            if (data == null) continue;
            for (int i = 0; i < data.length; ++i) {
                if (!(data[i] >= threshold)) continue;
                ret.add(gene);
                continue block0;
            }
        }
        return ret;
    }

    public Map<String, double[]> pairwiseCorrelation(List<String> genes) {
        int total = 0;
        SpearmansCorrelation spear = new SpearmansCorrelation();
        HashMap<String, double[]> ret = new HashMap<String, double[]>();
        for (int i = 1; i < genes.size(); ++i) {
            String gene = genes.get(i);
            double[] geneData = this.map.get(gene);
            double[] corrs = new double[i];
            for (int j = 0; j < i; ++j) {
                String other = genes.get(j);
                double[] otherData = this.map.get(other);
                corrs[j] = spear.correlation(geneData, otherData);
            }
            total += corrs.length;
            ret.put(gene, corrs);
        }
        return ret;
    }

    public List<String> filterGenesByThreshold(List<String> genes, double threshold) {
        ArrayList<String> ret = new ArrayList<String>();
        block0: for (String gene : genes) {
            double[] data = this.map.get(gene);
            if (data == null) continue;
            for (int i = 0; i < data.length; ++i) {
                if (!(data[i] >= threshold)) continue;
                ret.add(gene);
                continue block0;
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String[] descr = new String[]{"FixedTimeInc", "VarTimeInc", "DAG", "PCA_All", "PCA_Steep"};
        String[] unifiedFiles = new String[]{"/net/waterston/vol2/home/gevirl/Unification/TAF/Genes/NormalizeAllGenes.out", "/net/waterston/vol2/home/gevirl/Unification/Inc/Genes/AllGenes.out", "/net/waterston/vol2/home/gevirl/Unification/DAG/AllGenes.norm", "/net/waterston/vol2/home/gevirl/Unification/PCA/AllGenes.out", "/net/waterston/vol2/home/gevirl/SteepGenes/AllGenes.norm"};
        String[] pKDEFiles = new String[]{"/net/waterston/vol2/home/gevirl/Unification/TAF/Training/DataSourceJuly2013Stages40TrainingWithTimeInc.kde", "/net/waterston/vol2/home/gevirl/Unification/Inc/Training/FullDataGenesGreaterThan2Training.kde", "/net/waterston/vol2/home/gevirl/Unification/DAG/GeneTraining.kde", "/net/waterston/vol2/home/gevirl/Unification/PCA/TrainingSave/PCA_TrainingComplete.kde", "/net/waterston/vol2/home/gevirl/SteepGenes/TrainingComplete.kde"};
        String dataSourceXML = "/net/waterston/vol2/home/gevirl/Unification/Inc/Training/FullData.xml";
        PrintWriter writer = new PrintWriter(args[0]);
        writer.print("Descr,warp,no_warp\n");
        for (int i = 0; i < descr.length; ++i) {
            DataSource source = new DataSource(dataSourceXML);
            UnifiedResult result = new UnifiedResult(unifiedFiles[i]);
            PMatrixKdeFile pKdeFile = new PMatrixKdeFile(pKDEFiles[i]);
            double[] pseudoTimes = pKdeFile.getStageTimes(17);
            result.setUnifiedTimes(pseudoTimes);
            double error = result.rmsError(source, pKdeFile);
            int n = result.getN();
            double noWarpError = result.rmsErrorNoTimeWarping(source, pKdeFile);
            int n_nowarp = result.getN();
            writer.printf("%s,%f,%d,%f,%d\n", descr[i], error, n, noWarpError, n_nowarp);
            writer.flush();
        }
        writer.close();
    }

    public String getLabel() {
        return new File(this.resultFile).getName();
    }
}

