/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.decomp.XMatrix;
import org.rhwlab.DAG.decomp.ZMatrix;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.parameters.LogNonNegative;
import org.rhwlab.RNASeq.DataSource;
import org.rhwlab.RNASeq.KdeFile;
import org.rhwlab.RNASeq.PMatrixKdeFile;

public class Unification
extends Model {
    int N;
    DataSource source;
    KdeFile zKdeFile;
    PMatrixKdeFile pKdeFile;
    List<String> variableList;

    public Unification() {
    }

    public Unification(int N, DataSource source, KdeFile zKdeFile, PMatrixKdeFile pKdeFile, List<String> variableList) throws Exception {
        this.N = N;
        this.source = source;
        this.pKdeFile = pKdeFile;
        this.zKdeFile = zKdeFile;
        this.variableList = variableList;
    }

    @Override
    public void init() throws Exception {
        String[] experiments;
        ZMatrix Z = new ZMatrix(this.N, this.source, this, this.zKdeFile);
        Set features = this.source.getFeatures();
        HashMap<String, LogNonNegative> sigmaMap = new HashMap<String, LogNonNegative>();
        for (String experiment : experiments = this.source.getExperiments()) {
            double[] sampleTimes = this.source.getExperimentSource(experiment).getTimes();
            PMatrix P = new PMatrix(this.N, sampleTimes, experiment, this, this.pKdeFile);
            XMatrix xMatrix = new XMatrix(experiment, this.source, Z, P, sigmaMap, this);
        }
        this.setReportParams(this.variableList);
        super.init();
    }

    public void setN(Object n) {
        this.N = (Integer)n;
    }

    public void setSource(Object src) {
        this.source = (DataSource)src;
    }

    public void setZKDE(Object zKDE) {
        this.zKdeFile = (KdeFile)zKDE;
    }

    public void setPKDE(Object p) {
        this.pKdeFile = (PMatrixKdeFile)p;
    }

    public void setOutputFile(String outFile) throws Exception {
        this.setStream(new PrintStream(outFile));
    }

    public void setReportParametersFile(String file) throws Exception {
        this.variableList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            this.variableList.add(line);
            line = reader.readLine();
        }
        reader.close();
    }
}

