/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.rhwlab.DAG.decomp.UnifiedResult;
import org.rhwlab.DAG.views.CorrelationDistributionFrame;
import org.rhwlab.db.beans.ChromosomeFeatures;
import org.rhwlab.db.beans.Gene;

public class GenomicRegionUnifiedResult
extends UnifiedResult
implements ChromosomeFeatures {
    int width;
    HashMap<String, List<String>> chromoMap = new HashMap();
    HashMap<String, double[]> featureMap = new HashMap();

    public void init() {
        try {
            for (String chromo : CorrelationDistributionFrame.chromosomes) {
                ArrayList<String> features = new ArrayList<String>();
                this.chromoMap.put(chromo, features);
                ArrayList genes = Gene.getGenesOnChromosome((String)chromo);
                Gene lastGene = (Gene)genes.get(genes.size() - 1);
                int index = 0;
                int start = 1;
                while (start < lastGene.getRegion().getEnd()) {
                    int end = start + this.width - 1;
                    ArrayList<Gene> regionGenes = new ArrayList<Gene>();
                    while (index < genes.size()) {
                        Gene currentGene = (Gene)genes.get(index);
                        if (this.map.get(currentGene.getSequenceName()) != null) {
                            int geneStart = currentGene.getRegion().getStart();
                            if (start > geneStart || geneStart > end) break;
                            regionGenes.add(currentGene);
                            ++index;
                            continue;
                        }
                        ++index;
                    }
                    if (!regionGenes.isEmpty()) {
                        int i;
                        String name = ((Gene)regionGenes.get(0)).getSequenceName();
                        double[] data = (double[])this.map.get(name);
                        double[] sum = new double[data.length];
                        for (i = 0; i < sum.length; ++i) {
                            sum[i] = data[i];
                        }
                        for (int g = 1; g < regionGenes.size(); ++g) {
                            data = (double[])this.map.get(((Gene)regionGenes.get(g)).getSequenceName());
                            for (int i2 = 0; i2 < sum.length; ++i2) {
                                sum[i2] = sum[i2] + data[i2];
                            }
                        }
                        for (i = 0; i < sum.length; ++i) {
                            sum[i] = sum[i] / (double)regionGenes.size();
                        }
                        this.featureMap.put(name, sum);
                        features.add(name);
                    }
                    start = end + 1;
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public List<String> getSortedFeatures(String chromosome) throws Exception {
        return this.chromoMap.get(chromosome);
    }

    public double[] getFeatureData(String feature) {
        return this.featureMap.get(feature);
    }

    public void setWidth(Object obj) {
        this.width = (Integer)obj;
    }
}

