/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.decomp;

import java.io.PrintStream;
import org.rhwlab.DAG.Function;
import org.rhwlab.DAG.Node;
import org.rhwlab.DAG.decomp.PMatrix;
import org.rhwlab.DAG.models.Model;
import org.rhwlab.DAG.pipeline.Pipeline;

public class Convolved
extends Function {
    int column;
    Node[] zNodes;
    PMatrix P;

    public Convolved(String name, Node[] zNodes, PMatrix P, int column, Model model) {
        super(name, model);
        this.P = P;
        this.zNodes = zNodes;
        this.column = column;
        for (Node zNode : zNodes) {
            this.addParent(zNode);
        }
        this.addParent(P);
        this.update();
    }

    @Override
    public void update() {
        if (this.canUpdate()) {
            double mu = 0.0;
            double[] pCol = this.P.getColumn(this.column);
            for (int i = 0; i < this.zNodes.length; ++i) {
                double z = (Double)this.zNodes[i].getValue();
                mu += pCol[i] * z;
            }
            if (Pipeline.tracing) {
                System.out.printf("Convolved.update: name=%s\n", this.getName());
            }
            this.setValue(new Double(mu));
            if (Pipeline.dump) {
                this.dump(System.out);
            }
        }
    }

    public void dump(PrintStream stream) {
        stream.printf("Convolved: %s , Column=%d , value=%f\n", this.getName(), this.column, (Double)this.getValue());
        stream.print("zNodes: ");
        for (int i = 0; i < this.zNodes.length; ++i) {
            stream.printf("%f,", (Double)this.zNodes[i].getValue());
        }
        stream.print("\nP: ");
        double[] pCol = this.P.getColumn(this.column);
        for (int i = 0; i < pCol.length; ++i) {
            stream.printf("%f,", pCol[i]);
        }
        stream.println();
    }
}

