/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.views.ChangeNotifier;

public class RunTreePanel
extends ChangeNotifier {
    JPanel panel = new JPanel();
    JTree tree;

    public RunTreePanel() throws Exception {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        List<String> runs = ChangePointRun.allRuns();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ChangePointRuns");
        DefaultTreeModel model = new DefaultTreeModel(root);
        for (String run : runs) {
            ChangePointRun cpRun = new ChangePointRun(run);
            DefaultMutableTreeNode runNode = new DefaultMutableTreeNode(cpRun);
            root.add(runNode);
            for (String series : cpRun.getSeriesList()) {
                DefaultMutableTreeNode seriesNode = new DefaultMutableTreeNode(series);
                runNode.add(seriesNode);
            }
        }
        this.tree = new JTree(model);
        this.tree.getSelectionModel().setSelectionMode(1);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.tree);
        JButton button = new JButton("Display");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunTreePanel.this.notifyListeners();
            }
        });
        this.panel.add(scroll);
        this.panel.add(button);
    }

    public Object getSelected() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            return node.getUserObject();
        }
        return null;
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

