/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.views.ChangeNotifier;

public class RunHeaderPanel
extends ChangeNotifier {
    String series;
    ChangePointRun run;
    JTextField thresh;
    JPanel panel;

    public RunHeaderPanel(ChangePointRun run, String series, double th) {
        this.run = run;
        this.series = series;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(new JLabel(String.format("RunID: %s", run.getRunID())));
        this.panel.add(new JLabel(String.format("Run Series Count: %d", run.getSeriesList().size())));
        this.panel.add(new JLabel(String.format("Series: %s", series)));
        JPanel threshPanel = new JPanel();
        threshPanel.setLayout(new BoxLayout(threshPanel, 0));
        threshPanel.add(new JLabel("Prob Threshold: "));
        this.thresh = new JTextField(String.format("%f", th));
        this.thresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunHeaderPanel.this.notifyListeners();
            }
        });
        threshPanel.add(this.thresh);
        this.panel.add(threshPanel);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public ChangePointRun getRun() {
        return this.run;
    }

    public double getThreshold() {
        return Double.valueOf(this.thresh.getText());
    }

    public void setThreshold(double value) {
        this.thresh.setText(String.format("%f", value));
        this.notifyListeners();
    }

    public String getSeries() {
        return this.series;
    }
}

