/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.onsets.views.LeafView;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.expression.ExpressionTimeSeries;

public class MultipleSeriesLeafGroupPanel
extends JPanel {
    ChangePointRun run;
    List<ChangePointRun> runs;
    TreeMap<String, List<LeafView>> viewMap;

    public MultipleSeriesLeafGroupPanel(boolean logSpace, boolean fixedScale, boolean onsetOnly, ChangePointRun run, Map<String, List<EmbryoCell>> groupMap, Map<String, Integer> minExpMap, Map<String, Integer> maxExpMap) {
        this.run = run;
        this.viewMap = new TreeMap();
        this.setLayout(new BoxLayout(this, 0));
        for (String series : groupMap.keySet()) {
            ArrayList<LeafView> viewList = new ArrayList<LeafView>();
            List<EmbryoCell> cellList = groupMap.get(series);
            JPanel groupCellPanel = new JPanel();
            groupCellPanel.setLayout(new BoxLayout(groupCellPanel, 1));
            for (EmbryoCell cell : cellList) {
                ExpressionTimeSeries timeSeries = ExpressionTimeSeries.factory((EmbryoCell)cell);
                LeafView view = new LeafView(logSpace, fixedScale, onsetOnly, cell, timeSeries, minExpMap.get(series).intValue(), maxExpMap.get(series).intValue());
                groupCellPanel.add(view.getPanel());
                viewList.add(view);
            }
            this.add(groupCellPanel);
            this.viewMap.put(series, viewList);
        }
    }

    public void useThreshold(String series, double thresh) throws Exception {
        Map cpMap = this.run.getChangePoints(thresh);
        List<LeafView> viewList = this.viewMap.get(series);
        for (LeafView view : viewList) {
            if (view.getLeaf().getName().equals("ABprappppp")) {
                boolean bl = false;
            }
            CP_Segment[] segments = ChangePointRun.changePointSegments(view.getExpression(), view.getLeaf(), cpMap);
            view.useSegments(segments);
        }
    }
}

