/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.changepoints.views.MultipleRunLeafPanel;
import org.rhwlab.DAG.changepoints.views.MultipleSeriesLeafGroupPanel;
import org.rhwlab.DAG.changepoints.views.RunHeaderPanel;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.beans.SeriesEmbryo;
import org.rhwlab.beans.SulstonEmbryo;
import org.rhwlab.db.MySql;
import org.rhwlab.universalimaging.Embryo;

public class MultipleRunSeriesPanel
extends JPanel
implements ChangeListener {
    JPanel leavesPanel;
    JScrollPane scroll;
    JPanel headPanel;
    SulstonEmbryo sulston = new SulstonEmbryo(MySql.getMySql());
    double threshold = 0.5;
    static String[] lineages = new String[]{"P3", "C", "E", "MS", "ABpr", "ABpl", "ABar", "ABal"};

    public MultipleRunSeriesPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.add((Component)this.scroll, "Center");
        this.headPanel = new JPanel();
        this.headPanel.setLayout(new BoxLayout(this.headPanel, 0));
        this.scroll.setColumnHeaderView(this.headPanel);
    }

    public void useRun(ChangePointRun run, boolean logSpace, boolean fixedScale, boolean onsetsOnly) throws Exception {
        ArrayList<String> seriesList = run.getSeriesList();
        HashMap<String, SeriesEmbryo> embryoMap = new HashMap<String, SeriesEmbryo>();
        HashMap<String, Integer> minExpMap = new HashMap<String, Integer>();
        HashMap<String, Integer> maxExpMap = new HashMap<String, Integer>();
        this.headPanel.removeAll();
        for (String series : seriesList) {
            SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(), series, "zblot");
            minExpMap.put(series, embryo.minExpression());
            maxExpMap.put(series, embryo.maxExpression());
            this.sulston.sulstonize((Embryo)embryo);
            embryoMap.put(series, embryo);
            RunHeaderPanel runHead = new RunHeaderPanel(run, series, this.threshold);
            runHead.addListener(this);
            this.headPanel.add(runHead.getPanel());
            this.headPanel.add(Box.createHorizontalStrut(100));
        }
        this.leavesPanel = new JPanel();
        this.leavesPanel.setLayout(new BoxLayout(this.leavesPanel, 1));
        for (String lineage : lineages) {
            TreeMap<String, EmbryoCell> lineageMap = new TreeMap<String, EmbryoCell>();
            for (String series : seriesList) {
                EmbryoCell lineageCell = ((SeriesEmbryo)embryoMap.get(series)).getCell(lineage);
                lineageMap.put(series, lineageCell);
            }
            List groupList = EmbryoCell.terminalGroups(lineageMap);
            for (Map group : groupList) {
                MultipleSeriesLeafGroupPanel groupPanel = new MultipleSeriesLeafGroupPanel(logSpace, fixedScale, onsetsOnly, run, group, minExpMap, maxExpMap);
                Dimension groupDim = groupPanel.getPreferredSize();
                this.leavesPanel.add(groupPanel);
                Dimension headDim = this.headPanel.getPreferredSize();
                headDim.width = groupDim.width;
                this.headPanel.setPreferredSize(headDim);
            }
        }
        this.scroll.setViewportView(this.leavesPanel);
        for (String series : seriesList) {
            this.useThreshold(series, run, this.threshold);
        }
    }

    public void useSeries(String series, boolean logSpace, boolean fixedScale) throws Exception {
        this.leavesPanel = new JPanel();
        this.leavesPanel.setLayout(new BoxLayout(this.leavesPanel, 1));
        SeriesEmbryo embryo = new SeriesEmbryo(MySql.getMySql(), series, "zblot");
        this.sulston.sulstonize((Embryo)embryo);
        ArrayList<ChangePointRun> runList = new ArrayList<ChangePointRun>();
        for (String runID : ChangePointRun.runsForSeries(series)) {
            ChangePointRun run = new ChangePointRun(runID);
            runList.add(run);
        }
        double minExp = embryo.minExpression();
        double maxExp = embryo.maxExpression();
        EmbryoCell[] leaves = embryo.getAllLeaves();
        for (EmbryoCell leaf : leaves) {
            MultipleRunLeafPanel leafPanel = new MultipleRunLeafPanel(logSpace, fixedScale, runList, leaf, minExp, maxExp);
            this.leavesPanel.add(leafPanel);
        }
        this.scroll.setViewportView(this.leavesPanel);
        this.headPanel.removeAll();
        for (ChangePointRun run : runList) {
            RunHeaderPanel runHead = new RunHeaderPanel(run, series, this.threshold);
            runHead.addListener(this);
            this.headPanel.add(runHead.getPanel());
            this.headPanel.add(Box.createHorizontalStrut(100));
            runHead.setThreshold(this.threshold);
        }
    }

    public void useThreshold(String series, ChangePointRun run, double thresh) throws Exception {
        Component[] allComps;
        for (Component comp : allComps = this.leavesPanel.getComponents()) {
            if (comp instanceof MultipleRunLeafPanel) {
                MultipleRunLeafPanel leafPanel = (MultipleRunLeafPanel)comp;
                leafPanel.useThreshold(run, thresh);
                continue;
            }
            MultipleSeriesLeafGroupPanel groupPanel = (MultipleSeriesLeafGroupPanel)comp;
            groupPanel.useThreshold(series, thresh);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        RunHeaderPanel runHead = (RunHeaderPanel)e.getSource();
        try {
            this.useThreshold(runHead.getSeries(), runHead.getRun(), runHead.getThreshold());
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

