/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.DAG.changepoints.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.rhwlab.DAG.changepoints.CP_Segment;
import org.rhwlab.DAG.changepoints.ChangePointRun;
import org.rhwlab.DAG.onsets.views.LeafView;
import org.rhwlab.beans.EmbryoCell;
import org.rhwlab.expression.ExpressionTimeSeries;

public class MultipleRunLeafPanel
extends JPanel {
    List<ChangePointRun> runs;
    EmbryoCell leaf;
    Map<String, LeafView> viewMap;

    public MultipleRunLeafPanel(boolean logSpace, boolean fixedScale, List<ChangePointRun> runs, EmbryoCell leaf, double minExp, double maxExp) {
        this.runs = runs;
        this.leaf = leaf;
        this.setLayout(new BoxLayout(this, 0));
        ExpressionTimeSeries timeSeries = ExpressionTimeSeries.factory((EmbryoCell)leaf);
        this.viewMap = new HashMap<String, LeafView>();
        for (ChangePointRun run : runs) {
            LeafView view = new LeafView(logSpace, fixedScale, false, leaf, timeSeries, minExp, maxExp);
            this.viewMap.put(run.getRunID(), view);
            this.add(view.getPanel());
        }
    }

    public void useThreshold(ChangePointRun run, double thresh) throws Exception {
        LeafView view = this.viewMap.get(run.getRunID());
        CP_Segment[] segments = ChangePointRun.changePointSegments(view.getExpression(), this.leaf, run.getChangePoints(thresh));
        view.useSegments(segments);
    }
}

